<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e($lesson->title ?? $course->title); ?> – <?php echo e(config('app.name')); ?></title>
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=plus-jakarta-sans:400,500,600,700,800&display=swap" rel="stylesheet" />
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <style>
        [x-cloak] { display: none !important; }
        .scrollbar-hide::-webkit-scrollbar { display: none; }
        .scrollbar-hide { -ms-overflow-style: none; scrollbar-width: none; }
        .video-container { position: relative; padding-bottom: 56.25%; height: 0; overflow: hidden; }
        .video-container video { position: absolute; top: 0; left: 0; width: 100%; height: 100%; }
        @keyframes shimmer { 0% { background-position: -1000px 0; } 100% { background-position: 1000px 0; } }
        .shimmer { animation: shimmer 2s infinite linear; background: linear-gradient(to right, #f0f0f0 8%, #e0e0e0 18%, #f0f0f0 33%); background-size: 1000px 100%; }
    </style>
</head>
<body class="font-sans antialiased bg-white text-slate-900">
    <div class="min-h-screen flex flex-col">
        <?php echo $__env->make('partials.header-upgrad', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="flex-1 bg-slate-50">
            
            <div class="bg-white border-b border-slate-200/80 backdrop-blur-sm sticky top-0 z-50 shadow-sm">
                <div class="max-w-[1920px] mx-auto px-6 py-4">
                    <div class="flex items-center justify-between">
                        
                        <nav class="flex items-center gap-2.5 text-sm">
                            <a href="<?php echo e(route('home')); ?>" class="text-slate-500 hover:text-primary-600 font-medium transition-colors">Home</a>
                            <svg class="w-4 h-4 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
                            <span class="text-slate-900 font-semibold truncate max-w-md"><?php echo e($course->title); ?></span>
                        </nav>

                        
                        <div class="flex items-center gap-6">
                            <div class="hidden md:flex items-center gap-4">
                                <span class="text-sm font-semibold text-slate-600">Progress</span>
                                <div class="flex items-center gap-3">
                                    <div class="w-40 bg-slate-100 rounded-full h-2.5 overflow-hidden shadow-inner">
                                        <div class="bg-gradient-to-r from-primary-500 via-primary-600 to-primary-500 h-2.5 rounded-full transition-all duration-1000 ease-out shadow-sm" style="width: <?php echo e($enrollment->progress_percent ?? 0); ?>%"></div>
                                    </div>
                                    <span class="text-sm font-bold text-primary-600 min-w-[3.5rem] tabular-nums"><?php echo e(number_format($enrollment->progress_percent ?? 0, 1)); ?>%</span>
                                </div>
                            </div>
                            <div class="flex items-center gap-2">
                                <button class="p-2.5 text-slate-600 hover:text-primary-600 hover:bg-slate-50 rounded-lg transition-colors">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z"/></svg>
                                </button>
                                <button class="p-2.5 text-slate-600 hover:text-slate-900 hover:bg-slate-50 rounded-lg transition-colors">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 5v.01M12 12v.01M12 19v.01M12 6a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2zm0 7a1 1 0 110-2 1 1 0 010 2z"/></svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="flex flex-col lg:flex-row max-w-[1920px] mx-auto">
                
                <div class="flex-1 min-w-0 lg:w-[calc(100%-28rem)]">
                    <?php if(isset($lesson)): ?>
                        
                        <div class="relative bg-black group">
                            <div class="video-container">
                                <?php if($lesson->video_url): ?>
                                    <video class="w-full h-full" controls controlsList="nodownload" poster="">
                                        <source src="<?php echo e($lesson->video_url); ?>" type="video/mp4">
                                        Your browser does not support the video tag.
                                    </video>
                                <?php else: ?>
                                    <div class="absolute inset-0 flex items-center justify-center bg-gradient-to-br from-slate-900 via-black to-slate-900">
                                        <div class="text-center text-white px-6">
                                            <div class="w-28 h-28 mx-auto mb-6 relative">
                                                <div class="absolute inset-0 bg-primary-500/20 rounded-full animate-ping"></div>
                                                <div class="absolute inset-0 bg-primary-500/30 rounded-full animate-pulse"></div>
                                                <svg class="w-28 h-28 relative z-10 opacity-80" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M14.752 11.168l-3.197-2.132A1 1 0 0010 9.87v4.263a1 1 0 001.555.832l3.197-2.132a1 1 0 000-1.664z"/>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                                </svg>
                                            </div>
                                            <p class="text-xl font-semibold mb-2">Video content coming soon</p>
                                            <p class="text-slate-400 text-sm">We're preparing amazing content for you</p>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>

                            
                            <div class="absolute inset-0 pointer-events-none opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                                <?php if($prevLesson): ?>
                                    <a href="<?php echo e(route('courses.lesson', ['course' => $course, 'lesson' => $prevLesson])); ?>" 
                                       class="absolute left-8 top-1/2 -translate-y-1/2 pointer-events-auto w-16 h-16 bg-black/60 hover:bg-black/80 backdrop-blur-md rounded-full flex items-center justify-center text-white transition-all shadow-2xl hover:scale-110 group/nav">
                                        <svg class="w-8 h-8 group-hover/nav:-translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
                                    </a>
                                <?php endif; ?>
                                <?php if($nextLesson): ?>
                                    <a href="<?php echo e(route('courses.lesson', ['course' => $course, 'lesson' => $nextLesson])); ?>" 
                                       class="absolute right-8 top-1/2 -translate-y-1/2 pointer-events-auto w-16 h-16 bg-black/60 hover:bg-black/80 backdrop-blur-md rounded-full flex items-center justify-center text-white transition-all shadow-2xl hover:scale-110 group/nav">
                                        <svg class="w-8 h-8 group-hover/nav:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>

                        
                        <div class="bg-white border-b border-slate-200 px-8 py-6">
                            <div class="flex items-start justify-between gap-6">
                                <div class="flex-1 min-w-0">
                                    <div class="flex items-center gap-3 mb-3">
                                        <span class="px-3.5 py-1.5 bg-primary-50 text-primary-700 text-xs font-bold rounded-md border border-primary-200">Lesson <?php echo e($lesson->sort_order ?? 1); ?></span>
                                        <?php if($lesson->is_preview): ?>
                                            <span class="px-3.5 py-1.5 bg-green-50 text-green-700 text-xs font-semibold rounded-md border border-green-200">Free Preview</span>
                                        <?php endif; ?>
                                        <?php if($lesson->duration): ?>
                                            <span class="px-3.5 py-1.5 bg-slate-100 text-slate-700 text-xs font-medium rounded-md flex items-center gap-1.5">
                                                <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                                                <?php echo e($lesson->duration); ?> min
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    <h1 class="text-3xl font-extrabold text-slate-900 mb-3 leading-tight tracking-tight"><?php echo e($lesson->title); ?></h1>
                                    <?php if($lesson->content): ?>
                                        <p class="text-lg text-slate-600 leading-relaxed"><?php echo e($lesson->content); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        
                        <div class="bg-white border-b border-slate-200" x-data="{ activeTab: 'overview' }">
                            <div class="flex items-center gap-1 overflow-x-auto scrollbar-hide px-8">
                                <button @click="activeTab = 'overview'" 
                                        :class="activeTab === 'overview' ? 'text-primary-600 border-b-2 border-primary-600 font-bold' : 'text-slate-600 hover:text-slate-900 border-b-2 border-transparent'" 
                                        class="px-6 py-4 text-sm font-semibold whitespace-nowrap transition-all relative">
                                    Overview
                                </button>
                                <button @click="activeTab = 'qa'" 
                                        :class="activeTab === 'qa' ? 'text-primary-600 border-b-2 border-primary-600 font-bold' : 'text-slate-600 hover:text-slate-900 border-b-2 border-transparent'" 
                                        class="px-6 py-4 text-sm font-semibold whitespace-nowrap transition-all">
                                    Q&A
                                </button>
                                <button @click="activeTab = 'notes'" 
                                        :class="activeTab === 'notes' ? 'text-primary-600 border-b-2 border-primary-600 font-bold' : 'text-slate-600 hover:text-slate-900 border-b-2 border-transparent'" 
                                        class="px-6 py-4 text-sm font-semibold whitespace-nowrap transition-all">
                                    Notes
                                </button>
                                <button @click="activeTab = 'announcements'" 
                                        :class="activeTab === 'announcements' ? 'text-primary-600 border-b-2 border-primary-600 font-bold' : 'text-slate-600 hover:text-slate-900 border-b-2 border-transparent'" 
                                        class="px-6 py-4 text-sm font-semibold whitespace-nowrap transition-all">
                                    Announcements
                                </button>
                                <button @click="activeTab = 'reviews'" 
                                        :class="activeTab === 'reviews' ? 'text-primary-600 border-b-2 border-primary-600 font-bold' : 'text-slate-600 hover:text-slate-900 border-b-2 border-transparent'" 
                                        class="px-6 py-4 text-sm font-semibold whitespace-nowrap transition-all">
                                    Reviews
                                </button>
                            </div>
                        </div>

                        
                        <div class="bg-white min-h-[600px]">
                            <div x-show="activeTab === 'overview'" x-cloak class="p-8 lg:p-12">
                                <div class="max-w-4xl">
                                    
                                    <div class="bg-gradient-to-br from-slate-50 to-white rounded-2xl p-8 mb-8 border border-slate-200 shadow-sm">
                                        <h2 class="text-3xl font-extrabold text-slate-900 mb-4"><?php echo e($course->title); ?></h2>
                                        <p class="text-lg text-slate-700 mb-8 leading-relaxed"><?php echo e($course->description); ?></p>

                                        
                                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-8 pb-8 border-b border-slate-200">
                                            <div class="flex items-center gap-3 p-4 bg-yellow-50 rounded-xl border border-yellow-100">
                                                <div class="flex items-center">
                                                    <?php for($i = 1; $i <= 5; $i++): ?>
                                                        <svg class="w-4 h-4 <?php echo e($i <= ($course->rating ?? 4.5) ? 'text-yellow-400' : 'text-slate-300'); ?>" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                                                    <?php endfor; ?>
                                                </div>
                                                <span class="text-sm font-bold text-slate-900"><?php echo e(number_format($course->rating ?? 4.5, 1)); ?></span>
                                            </div>
                                            <div class="flex items-center gap-3 p-4 bg-blue-50 rounded-xl border border-blue-100">
                                                <svg class="w-5 h-5 text-blue-600 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/></svg>
                                                <div>
                                                    <div class="text-xs text-slate-600">Students</div>
                                                    <div class="text-sm font-bold text-slate-900"><?php echo e(number_format($course->enrollments->count() ?? 6980)); ?></div>
                                                </div>
                                            </div>
                                            <div class="flex items-center gap-3 p-4 bg-purple-50 rounded-xl border border-purple-100">
                                                <svg class="w-5 h-5 text-purple-600 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                                                <div>
                                                    <div class="text-xs text-slate-600">Duration</div>
                                                    <div class="text-sm font-bold text-slate-900"><?php echo e(round($course->total_duration / 60) ?? 19); ?>h</div>
                                                </div>
                                            </div>
                                            <div class="flex items-center gap-3 p-4 bg-green-50 rounded-xl border border-green-100">
                                                <svg class="w-5 h-5 text-green-600 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/></svg>
                                                <div>
                                                    <div class="text-xs text-slate-600">Updated</div>
                                                    <div class="text-sm font-bold text-slate-900"><?php echo e($course->updated_at->format('M Y')); ?></div>
                                                </div>
                                            </div>
                                        </div>

                                        
                                        <?php if($course->syllabus): ?>
                                            <div class="mb-8">
                                                <h3 class="text-2xl font-bold text-slate-900 mb-6 flex items-center gap-3">
                                                    <div class="w-1 h-8 bg-gradient-to-b from-primary-500 to-primary-600 rounded-full"></div>
                                                    What you'll learn
                                                </h3>
                                                <div class="grid md:grid-cols-2 gap-3">
                                                    <?php $__currentLoopData = array_slice(explode("\n", $course->syllabus), 0, 8); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(trim($point)): ?>
                                                            <div class="flex items-start gap-3 p-3 rounded-lg hover:bg-slate-50 transition">
                                                                <svg class="w-5 h-5 text-primary-600 shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/></svg>
                                                                <span class="text-slate-700 font-medium text-sm leading-relaxed"><?php echo e(trim($point)); ?></span>
                                                            </div>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        
                                        <div class="mb-8">
                                            <h3 class="text-2xl font-bold text-slate-900 mb-4 flex items-center gap-3">
                                                <div class="w-1 h-8 bg-gradient-to-b from-primary-500 to-primary-600 rounded-full"></div>
                                                Description
                                            </h3>
                                            <div class="prose prose-slate max-w-none text-slate-700 whitespace-pre-line leading-relaxed">
                                                <?php echo e($course->syllabus ?? $course->description); ?>

                                            </div>
                                        </div>

                                        
                                        <?php if($course->instructor): ?>
                                            <div class="mb-6 pb-6 border-b border-slate-200">
                                                <h3 class="text-2xl font-bold text-slate-900 mb-4 flex items-center gap-3">
                                                    <div class="w-1 h-8 bg-gradient-to-b from-primary-500 to-primary-600 rounded-full"></div>
                                                    Instructor
                                                </h3>
                                                <div class="flex items-start gap-5 p-6 bg-gradient-to-br from-slate-50 to-white rounded-xl border border-slate-200">
                                                    <div class="w-16 h-16 rounded-full bg-gradient-to-br from-primary-500 to-primary-600 flex items-center justify-center text-white text-xl font-bold shrink-0 shadow-lg">
                                                        <?php echo e(strtoupper(substr($course->instructor->name, 0, 1))); ?>

                                                    </div>
                                                    <div class="flex-1">
                                                        <h4 class="font-bold text-slate-900 text-lg mb-1"><?php echo e($course->instructor->name); ?></h4>
                                                        <p class="text-slate-600 text-sm mb-3"><?php echo e($course->instructor->email); ?></p>
                                                        <p class="text-slate-700 text-sm leading-relaxed">Experienced instructor dedicated to your learning success.</p>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        
                                        <div>
                                            <h3 class="text-2xl font-bold text-slate-900 mb-4 flex items-center gap-3">
                                                <div class="w-1 h-8 bg-gradient-to-b from-primary-500 to-primary-600 rounded-full"></div>
                                                Requirements
                                            </h3>
                                            <ul class="space-y-2">
                                                <li class="flex items-start gap-3 p-3 rounded-lg hover:bg-slate-50 transition">
                                                    <span class="text-primary-600 mt-1 text-lg font-bold">•</span>
                                                    <span class="text-slate-700 font-medium text-sm">Basic understanding of the subject matter</span>
                                                </li>
                                                <li class="flex items-start gap-3 p-3 rounded-lg hover:bg-slate-50 transition">
                                                    <span class="text-primary-600 mt-1 text-lg font-bold">•</span>
                                                    <span class="text-slate-700 font-medium text-sm">Access to a computer with internet connection</span>
                                                </li>
                                                <li class="flex items-start gap-3 p-3 rounded-lg hover:bg-slate-50 transition">
                                                    <span class="text-primary-600 mt-1 text-lg font-bold">•</span>
                                                    <span class="text-slate-700 font-medium text-sm">Willingness to learn and practice</span>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            
                            <div x-show="activeTab !== 'overview'" x-cloak class="p-8 lg:p-12">
                                <div class="max-w-4xl mx-auto">
                                    <div class="bg-white rounded-2xl p-12 text-center border border-slate-200">
                                        <svg class="w-16 h-16 text-slate-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/></svg>
                                        <p class="text-lg text-slate-600 font-medium">This section is coming soon.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="p-12 text-center text-white bg-slate-900">
                            <p class="text-xl font-semibold">No lessons available yet.</p>
                        </div>
                    <?php endif; ?>
                </div>

                
                <div class="w-full lg:w-[28rem] bg-white border-l border-slate-200 shadow-xl overflow-y-auto" style="max-height: calc(100vh - 64px);">
                    <div class="sticky top-0 bg-white z-20 border-b border-slate-200 p-6 shadow-sm">
                        <h2 class="text-xl font-bold text-slate-900 mb-1 flex items-center gap-2">
                            <svg class="w-5 h-5 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/></svg>
                            Course content
                        </h2>
                        <p class="text-sm text-slate-500"><?php echo e($course->lessons->count()); ?> lessons</p>
                    </div>
                    <?php
                        $openSectionIndex = 0;
                        if (isset($lesson) && isset($sections)) {
                            foreach ($sections as $idx => $section) {
                                foreach ($section['lessons'] as $l) {
                                    if ($l->id === $lesson->id) {
                                        $openSectionIndex = $idx;
                                        break 2;
                                    }
                                }
                            }
                        }
                    ?>
                    <div class="p-4" x-data="{ openSections: [<?php echo e($openSectionIndex); ?>] }">
                        <?php $__currentLoopData = $sections ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sectionIndex => $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mb-2">
                                <button 
                                    @click="openSections.includes(<?php echo e($sectionIndex); ?>) ? openSections = openSections.filter(s => s !== <?php echo e($sectionIndex); ?>) : openSections.push(<?php echo e($sectionIndex); ?>)"
                                    class="w-full flex items-center justify-between p-4 text-left hover:bg-slate-50 transition rounded-xl border border-slate-200 hover:border-primary-200 hover:shadow-sm group"
                                >
                                    <div class="flex-1 min-w-0 pr-3">
                                        <span class="font-bold text-slate-900 text-sm block truncate group-hover:text-primary-600 transition"><?php echo e($section['title']); ?></span>
                                        <span class="text-xs text-slate-500 mt-1"><?php echo e(count($section['lessons'])); ?> lessons</span>
                                    </div>
                                    <svg class="w-5 h-5 text-slate-400 transition-transform shrink-0" :class="openSections.includes(<?php echo e($sectionIndex); ?>) && 'rotate-180 text-primary-600'" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                    </svg>
                                </button>
                                <div x-show="openSections.includes(<?php echo e($sectionIndex); ?>)" 
                                     x-transition:enter="transition ease-out duration-200"
                                     x-transition:enter-start="opacity-0 transform -translate-y-2"
                                     x-transition:enter-end="opacity-100 transform translate-y-0"
                                     x-cloak 
                                     class="ml-2 mt-2 space-y-1 border-l-2 border-slate-200 pl-4">
                                    <?php $__currentLoopData = $section['lessons']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $l): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="<?php echo e(route('courses.lesson', ['course' => $course, 'lesson' => $l])); ?>" 
                                           class="flex items-center justify-between p-3 rounded-lg hover:bg-gradient-to-r hover:from-primary-50 hover:to-transparent transition-all group <?php echo e(isset($lesson) && $lesson->id === $l->id ? 'bg-gradient-to-r from-primary-50 to-transparent border-l-4 border-primary-600 shadow-sm' : ''); ?>">
                                            <div class="flex items-center gap-3 flex-1 min-w-0">
                                                <div class="relative shrink-0">
                                                    <div class="w-5 h-5 rounded border-2 <?php echo e(isset($lesson) && $lesson->id === $l->id ? 'border-primary-600 bg-primary-600' : 'border-slate-300'); ?> flex items-center justify-center transition">
                                                        <?php if(isset($lesson) && $lesson->id === $l->id): ?>
                                                            <svg class="w-3 h-3 text-white" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/></svg>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <span class="text-sm text-slate-700 group-hover:text-primary-600 truncate font-medium <?php echo e(isset($lesson) && $lesson->id === $l->id ? 'font-bold text-primary-600' : ''); ?> transition">
                                                    <?php echo e($l->title); ?>

                                                </span>
                                            </div>
                                            <?php if($l->duration): ?>
                                                <span class="text-xs text-slate-500 ml-3 shrink-0 font-medium bg-slate-100 px-2 py-1 rounded"><?php echo e($l->duration); ?>m</span>
                                            <?php endif; ?>
                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </main>
    </div>
    <?php if(auth()->guard()->guest()): ?>
        <?php echo $__env->make('partials.auth-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php endif; ?>
</body>
</html>
<?php /**PATH /Library/WebServer/Documents/iid-new-project/products/e-commerce/lms-portal/resources/views/courses/learn.blade.php ENDPATH**/ ?>