<?php

namespace App\Http\Controllers;

use App\Models\Notification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class NotificationController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of notifications for the current user.
     */
    public function index()
    {
        $notifications = Auth::user()->notifications()
            ->with('document')
            ->orderBy('created_at', 'desc')
            ->paginate(20);

        return view('notifications.index', compact('notifications'));
    }

    /**
     * Mark a specific notification as read.
     */
    public function markAsRead(Notification $notification)
    {
        // Ensure the notification belongs to the current user
        if ($notification->user_id !== Auth::id()) {
            abort(403, 'You can only mark your own notifications as read.');
        }

        $notification->markAsRead();

        return response()->json(['success' => true]);
    }

    /**
     * Mark all notifications as read for the current user.
     */
    public function markAllAsRead()
    {
        Auth::user()->notifications()
            ->where('read_status', false)
            ->update(['read_status' => true]);

        return response()->json(['success' => true]);
    }

    /**
     * Get unread notifications count for the current user.
     */
    public function getUnreadCount()
    {
        $count = Auth::user()->notifications()
            ->where('read_status', false)
            ->count();

        return response()->json(['count' => $count]);
    }
}
