<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'document_id',
        'message',
        'read_status'
    ];

    protected $casts = [
        'read_status' => 'boolean',
    ];

    /**
     * Get the user this notification belongs to.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the document related to this notification.
     */
    public function document()
    {
        return $this->belongsTo(Document::class);
    }

    /**
     * Mark this notification as read.
     */
    public function markAsRead()
    {
        $this->update(['read_status' => true]);
    }
}
