<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDocumentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('documents', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->enum('type', ['Design', 'MAS', 'TQ', 'ST', 'Material Inspection']);
            $table->string('file_path');
            $table->enum('current_status', [
                'Pending Consultant Review',
                'Rejected by Consultant',
                'Pending Client A Review',
                'Rejected by Client A',
                'Pending Client B & C Review',
                'Rejected by Client B/C',
                'Final Approved'
            ])->default('Pending Consultant Review');
            $table->foreignId('contractor_id')->constrained('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('documents');
    }
}
