<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Create roles
        $roles = [
            'SuperAdmin',
            'Contractor',
            'Consultant',
            'ClientA',
            'ClientB',
            'ClientC'
        ];

        foreach ($roles as $role) {
            Role::firstOrCreate(['name' => $role]);
        }

        // Create permissions
        $permissions = [
            'upload-document',
            'view-own-documents',
            'review-contractor-documents',
            'review-consultant-approved-documents',
            'reject-documents',
            'view-all-documents',
            'manage-users',
            'create-users',
            'delete-users',
            'view-system-analytics',
            'manage-system-settings',
            'view-all-approvals',
            'access-admin-panel'
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Assign permissions to roles
        $superAdmin = Role::findByName('SuperAdmin');
        $superAdmin->givePermissionTo(Permission::all()); // All permissions

        $contractor = Role::findByName('Contractor');
        $contractor->givePermissionTo(['upload-document', 'view-own-documents']);

        $consultant = Role::findByName('Consultant');
        $consultant->givePermissionTo(['review-contractor-documents', 'view-all-documents', 'manage-users']);

        $clientA = Role::findByName('ClientA');
        $clientA->givePermissionTo(['review-consultant-approved-documents', 'view-all-documents', 'manage-users']);

        $clientB = Role::findByName('ClientB');
        $clientB->givePermissionTo(['reject-documents', 'view-all-documents']);

        $clientC = Role::findByName('ClientC');
        $clientC->givePermissionTo(['reject-documents', 'view-all-documents']);
    }
}
