<x-app-layout>
    <x-slot name="header">
        <div class="page-header">
            <div class="flex items-center">
                <svg class="w-8 h-8 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"></path>
                </svg>
                <div>
                    <h2 class="font-bold text-2xl mb-1">⏳ Pending Approvals</h2>
                    <p class="text-blue-100">Documents requiring your review and approval</p>
                </div>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="card animate-fade-in">
                <div class="card-header">
                    <div class="flex items-center justify-between">
                        <h3 class="text-lg font-bold text-gray-800">Documents Requiring Your Review</h3>
                        @if($documents->count() > 0)
                            <span class="status-badge status-warning">
                                {{ $documents->count() }} pending
                            </span>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    @if($documents->count() > 0)
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                            @foreach($documents as $document)
                                <div class="bg-white border border-gray-200 rounded-lg shadow-sm hover:shadow-lg transition-all duration-300 animate-scale-in animate-stagger-{{ $loop->index % 6 + 1 }} hover-lift hover-glow">
                                    <div class="p-6">
                                        <div class="flex items-start justify-between mb-4">
                                            <div class="flex-1">
                                                <h4 class="text-lg font-semibold text-gray-900 mb-1 hover-scale transition-transform duration-200">{{ $document->title }}</h4>
                                                <p class="text-sm text-gray-600">{{ $document->type }}</p>
                                            </div>
                                            <span class="status-badge status-pending">
                                                {{ $document->current_status }}
                                            </span>
                                        </div>

                                        <div class="space-y-2 mb-4">
                                            <div class="flex items-center text-sm text-gray-600">
                                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                                </svg>
                                                {{ $document->contractor->name }}
                                            </div>
                                            <div class="flex items-center text-sm text-gray-600">
                                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                </svg>
                                                {{ $document->created_at->diffForHumans() }}
                                            </div>
                                            <div class="flex items-center text-sm text-gray-600">
                                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a1.994 1.994 0 01-1.414.586H7a4 4 0 01-4-4V7a4 4 0 014-4z"></path>
                                                </svg>
                                                Version {{ $document->versions->max('version_number') ?? 1 }}
                                            </div>
                                        </div>

                                        <div class="flex space-x-3 animate-slide-up animate-stagger-2">
                                            <a href="{{ route('approvals.show', $document) }}" class="btn btn-primary flex-1 justify-center hover-glow animate-scale-in animate-stagger-1">
                                                <svg class="w-4 h-4 mr-2 animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"></path>
                                                </svg>
                                                <span class="font-bold">Review Document</span>
                                            </a>
                                            <a href="{{ route('documents.show', $document) }}" class="btn btn-white hover-scale animate-scale-in animate-stagger-2">
                                                <svg class="w-4 h-4 animate-float" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                                </svg>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-12">
                            <svg class="mx-auto h-16 w-16 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"></path>
                            </svg>
                            <h3 class="mt-4 text-lg font-medium text-gray-900">No pending approvals</h3>
                            <p class="mt-2 text-sm text-gray-500">
                                @if(Auth::user()->hasRole('Consultant'))
                                    There are no documents waiting for consultant review at this time.
                                @elseif(Auth::user()->hasRole('ClientA'))
                                    There are no documents waiting for Client A review at this time.
                                @elseif(Auth::user()->hasRole(['ClientB', 'ClientC']))
                                    There are no documents waiting for final client review at this time.
                                @endif
                            </p>
                            <div class="mt-6">
                                <a href="{{ route('documents.index') }}" class="btn btn-primary">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                    </svg>
                                    View All Documents
                                </a>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            @if($documents->count() > 0)
                <!-- Quick Actions -->
                <div class="card mt-6">
                    <div class="card-header">
                        <h3 class="text-lg font-bold text-gray-800">Quick Actions</h3>
                    </div>
                    <div class="card-body">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div class="text-center p-4 bg-blue-50 rounded-lg">
                                <div class="text-2xl font-bold text-blue-600">{{ $documents->count() }}</div>
                                <div class="text-sm text-gray-600">Pending Reviews</div>
                            </div>
                            <div class="text-center p-4 bg-green-50 rounded-lg">
                                <div class="text-2xl font-bold text-green-600">
                                    {{ Auth::user()->approvals()->where('status', 'approved')->count() }}
                                </div>
                                <div class="text-sm text-gray-600">Total Approved</div>
                            </div>
                            <div class="text-center p-4 bg-red-50 rounded-lg">
                                <div class="text-2xl font-bold text-red-600">
                                    {{ Auth::user()->approvals()->where('status', 'rejected')->count() }}
                                </div>
                                <div class="text-sm text-gray-600">Total Rejected</div>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</x-app-layout>
