<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <title>Login - ConstructFlow</title>

        <!-- Fonts -->
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

        <!-- Scripts -->
        <link href="{{ mix('css/app.css') }}" rel="stylesheet">
        <script src="{{ mix('js/app.js') }}" defer></script>
    </head>
    <body class="font-sans antialiased bg-gradient-to-br from-blue-50 via-white to-indigo-50 min-h-screen">
        <div class="min-h-screen flex">
            <!-- Left Side - Branding -->
            <div class="hidden lg:flex lg:w-1/2 bg-gradient-to-br from-blue-600 to-purple-700 relative overflow-hidden">
                <div class="absolute inset-0 bg-black opacity-20"></div>
                <div class="relative z-10 flex flex-col justify-center px-12 text-white">
                    <div class="mb-8 animate-slide-right">
                        <div class="flex items-center mb-6 animate-scale-in">
                            <svg class="h-12 w-12 text-white animate-float" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                            </svg>
                            <span class="ml-3 text-3xl font-bold animate-glow">ConstructFlow</span>
                        </div>
                        <h1 class="text-4xl font-bold mb-4 animate-fade-in animate-stagger-2">
                            Construction Document Management System
                        </h1>
                        <p class="text-xl text-blue-100 mb-8 animate-slide-up animate-stagger-3">
                            Streamline your construction project workflows with automated document approval processes and real-time collaboration.
                        </p>
                    </div>

                    <!-- Features List -->
                    <div class="space-y-4 animate-fade-in animate-stagger-4">
                        <div class="flex items-center animate-slide-left animate-stagger-1 hover-scale">
                            <svg class="w-5 h-5 text-green-400 mr-3 animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span class="text-blue-100">Role-based access control</span>
                        </div>
                        <div class="flex items-center animate-slide-left animate-stagger-2 hover-scale">
                            <svg class="w-5 h-5 text-green-400 mr-3 animate-bounce-in" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span class="text-blue-100">Automated approval workflow</span>
                        </div>
                        <div class="flex items-center animate-slide-left animate-stagger-3 hover-scale">
                            <svg class="w-5 h-5 text-green-400 mr-3 animate-float" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span class="text-blue-100">Real-time notifications</span>
                        </div>
                        <div class="flex items-center animate-slide-left animate-stagger-4 hover-scale">
                            <svg class="w-5 h-5 text-green-400 mr-3 animate-glow" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span class="text-blue-100">Comprehensive analytics</span>
                        </div>
                    </div>

                    <!-- Construction Graphics -->
                    <div class="absolute bottom-0 right-0 opacity-20">
                        <svg class="w-64 h-64" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Right Side - Login Form -->
            <div class="flex-1 flex flex-col justify-center py-12 px-4 sm:px-6 lg:px-20 xl:px-24">
                <div class="mx-auto w-full max-w-sm lg:w-96">
                    <div class="text-center mb-8 animate-slide-left">
                        <div class="flex items-center justify-center mb-4 animate-scale-in">
                            <svg class="h-10 w-10 text-blue-600 animate-pulse-slow" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                            </svg>
                            <span class="ml-2 text-2xl font-bold text-gray-900 animate-glow">ConstructFlow</span>
                        </div>
                        <h2 class="text-3xl font-bold text-gray-900 animate-fade-in animate-stagger-2">Welcome back</h2>
                        <p class="mt-2 text-sm text-gray-600 animate-slide-up animate-stagger-3">
                            Sign in to access your construction document management dashboard
                        </p>
                    </div>

        <!-- Session Status -->
                    @if (session('status'))
                        <div class="alert alert-success animate-fade-in">
                            {{ session('status') }}
                        </div>
                    @endif

        <!-- Validation Errors -->
                    @if ($errors->any())
                        <div class="alert alert-error animate-fade-in">
                            <strong>Please fix the following errors:</strong>
                            <ul class="list-disc list-inside mt-2">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('login') }}" class="login-form space-y-6 animate-fade-in animate-stagger-4">
            @csrf

                        <div class="animate-slide-up animate-stagger-1">
                            <label for="email" class="form-label">
                                <svg class="w-4 h-4 mr-1 inline animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207"></path>
                                </svg>
                                Email Address
                            </label>
                            <input id="email" name="email" type="email" value="{{ old('email') }}" required autofocus
                                placeholder="Enter your email address"
                                class="form-input hover-glow transition-all duration-300">
            </div>

                        <div class="animate-slide-up animate-stagger-2">
                            <label for="password" class="form-label">
                                <svg class="w-4 h-4 mr-1 inline animate-float" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                                </svg>
                                Password
                            </label>
                            <input id="password" name="password" type="password" required
                                placeholder="Enter your password"
                                class="form-input hover-glow transition-all duration-300">
            </div>

                        <div class="flex items-center justify-between">
                            <div class="flex items-center">
                                <input id="remember_me" name="remember" type="checkbox" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                <label for="remember_me" class="ml-2 block text-sm text-gray-900">
                                    Remember me
                </label>
            </div>

                @if (Route::has('password.request'))
                                <div class="text-sm">
                                    <a href="{{ route('password.request') }}" class="font-medium text-blue-600 hover:text-blue-500">
                                        Forgot your password?
                    </a>
                                </div>
                @endif
                        </div>

                        <div class="animate-slide-up animate-stagger-4">
                            <button type="submit" class="btn btn-primary w-full justify-center btn-lg hover-glow animate-bounce-in animate-stagger-5">
                                <svg class="w-5 h-5 mr-2 animate-float" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path>
                                </svg>
                                <span class="font-bold">Sign in to ConstructFlow</span>
                            </button>
                        </div>
                    </form>

                    <!-- Demo Users Info -->
                    <div class="mt-8 p-4 bg-blue-50 rounded-lg border border-blue-200">
                        <h3 class="text-sm font-semibold text-blue-900 mb-2">Demo Accounts Available:</h3>
                        <div class="text-xs text-blue-800 space-y-1">
                            <div><strong>SuperAdmin:</strong> admin@test.com / password</div>
                            <div><strong>Contractor:</strong> contractor@test.com / password</div>
                            <div><strong>Consultant:</strong> consultant@test.com / password</div>
                            <div><strong>Client A:</strong> clienta@test.com / password</div>
                            <div><strong>Client B:</strong> clientb@test.com / password</div>
                            <div><strong>Client C:</strong> clientc@test.com / password</div>
                        </div>
                    </div>

                    <div class="mt-6 text-center">
                        <a href="{{ url('/') }}" class="text-blue-600 hover:text-blue-500 text-sm font-medium">
                            ← Back to home page
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>
