<!-- Client A Dashboard Statistics -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-blue-600 mb-2">{{ $queueCount ?? 0 }}</div>
            <div class="text-sm text-gray-600">Queue Count</div>
            <div class="text-xs text-gray-500 mt-1">Consultant Approved</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-gray-600 mb-2">{{ $totalApprovals ?? 0 }}</div>
            <div class="text-sm text-gray-600">Total Reviews</div>
            <div class="text-xs text-gray-500 mt-1">Completed</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-green-600 mb-2">{{ $approved ?? 0 }}</div>
            <div class="text-sm text-gray-600">Approved</div>
            <div class="text-xs text-gray-500 mt-1">Documents</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-red-600 mb-2">{{ $rejected ?? 0 }}</div>
            <div class="text-sm text-gray-600">Rejected</div>
            <div class="text-xs text-gray-500 mt-1">Documents</div>
        </div>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
    <!-- Documents in Queue -->
    <div class="card">
        <div class="card-header">
            <div class="flex items-center justify-between">
                <h3 class="text-lg font-bold text-gray-800">Documents in Queue</h3>
                @if(isset($documentsInQueue) && $documentsInQueue->count() > 0)
                    <span class="status-badge status-pending">{{ $documentsInQueue->count() }}</span>
                @endif
            </div>
        </div>
        <div class="card-body">
            @if(isset($documentsInQueue) && $documentsInQueue->count() > 0)
                <div class="space-y-4">
                    @foreach($documentsInQueue->take(5) as $document)
                        <div class="flex items-center justify-between p-4 bg-blue-50 rounded-lg border-l-4 border-blue-400">
                            <div class="flex-1">
                                <h4 class="font-medium text-gray-900">{{ $document->title }}</h4>
                                <p class="text-sm text-gray-600">{{ $document->type }} • {{ $document->contractor->name }}</p>
                                <p class="text-xs text-gray-500">Consultant approved {{ $document->updated_at->diffForHumans() }}</p>
                            </div>
                            <div class="flex space-x-2">
                                <a href="{{ route('approvals.show', $document) }}" class="btn btn-primary btn-sm">
                                    Review
                                </a>
                                <a href="{{ route('documents.show', $document) }}" class="btn btn-secondary btn-sm">
                                    View
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
                @if($documentsInQueue->count() > 5)
                    <div class="mt-4 text-center">
                        <a href="{{ route('approvals.index') }}" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                            View All {{ $documentsInQueue->count() }} Documents →
                        </a>
                    </div>
                @endif
            @else
                <div class="text-center py-8">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"></path>
                    </svg>
                    <h3 class="mt-2 text-sm font-medium text-gray-900">No documents in queue</h3>
                    <p class="mt-1 text-sm text-gray-500">No documents are waiting for your review.</p>
                </div>
            @endif
        </div>
    </div>

    <!-- Quick Action Panel -->
    <div class="card">
        <div class="card-header">
            <h3 class="text-lg font-bold text-gray-800">Quick Actions</h3>
        </div>
        <div class="card-body">
            <div class="space-y-4">
                <a href="{{ route('approvals.index') }}" class="block p-4 bg-orange-50 rounded-lg border border-orange-200 hover:bg-orange-100 transition-colors">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <svg class="h-8 w-8 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"></path>
                            </svg>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-900">Review Documents</p>
                            <p class="text-sm text-gray-500">{{ $queueCount ?? 0 }} documents waiting</p>
                        </div>
                    </div>
                </a>

                <a href="{{ route('documents.index') }}" class="block p-4 bg-blue-50 rounded-lg border border-blue-200 hover:bg-blue-100 transition-colors">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <svg class="h-8 w-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-900">Browse All Documents</p>
                            <p class="text-sm text-gray-500">View complete document library</p>
                        </div>
                    </div>
                </a>

                <a href="{{ route('users.index') }}" class="block p-4 bg-gray-50 rounded-lg border border-gray-200 hover:bg-gray-100 transition-colors">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <svg class="h-8 w-8 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                            </svg>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-gray-900">Manage Users</p>
                            <p class="text-sm text-gray-500">Assign roles and permissions</p>
                        </div>
                    </div>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Weekly Approval Trends Chart -->
@if(isset($weeklyApprovals) && $weeklyApprovals->count() > 0)
<div class="card">
    <div class="card-header">
        <h3 class="text-lg font-bold text-gray-800">Weekly Approval Trends</h3>
    </div>
    <div class="card-body">
        <canvas id="weeklyApprovalChart" width="800" height="300"></canvas>
    </div>
</div>
@endif

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Weekly Approval Trends Line Chart
    @if(isset($weeklyApprovals) && $weeklyApprovals->count() > 0)
    const weeklyApprovalCtx = document.getElementById('weeklyApprovalChart').getContext('2d');
    new Chart(weeklyApprovalCtx, {
        type: 'line',
        data: {
            labels: [
                @foreach($weeklyApprovals as $week)
                    'Week {{ $week->week }}',
                @endforeach
            ],
            datasets: [{
                label: 'Approved',
                data: [
                    @foreach($weeklyApprovals as $week)
                        {{ $week->approved }},
                    @endforeach
                ],
                borderColor: '#10B981',
                backgroundColor: 'rgba(16, 185, 129, 0.1)',
                tension: 0.4,
                fill: true,
                pointBackgroundColor: '#10B981',
                pointBorderColor: '#059669',
                pointBorderWidth: 2,
                pointRadius: 6
            }, {
                label: 'Rejected',
                data: [
                    @foreach($weeklyApprovals as $week)
                        {{ $week->rejected }},
                    @endforeach
                ],
                borderColor: '#EF4444',
                backgroundColor: 'rgba(239, 68, 68, 0.1)',
                tension: 0.4,
                fill: true,
                pointBackgroundColor: '#EF4444',
                pointBorderColor: '#DC2626',
                pointBorderWidth: 2,
                pointRadius: 6
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            interaction: {
                intersect: false,
                mode: 'index'
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    },
                    grid: {
                        color: 'rgba(0, 0, 0, 0.1)'
                    }
                },
                x: {
                    grid: {
                        color: 'rgba(0, 0, 0, 0.1)'
                    }
                }
            },
            plugins: {
                legend: {
                    position: 'top',
                    labels: {
                        usePointStyle: true,
                        padding: 20
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(0, 0, 0, 0.8)',
                    titleColor: '#ffffff',
                    bodyColor: '#ffffff',
                    borderColor: 'rgba(255, 255, 255, 0.1)',
                    borderWidth: 1
                }
            }
        }
    });
    @endif
});
</script>
