<!-- Consultant Dashboard Statistics -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-orange-600 mb-2">{{ $pendingReviews ?? 0 }}</div>
            <div class="text-sm text-gray-600">Pending Reviews</div>
            <div class="text-xs text-gray-500 mt-1">Require Action</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-gray-600 mb-2">{{ $totalApprovals ?? 0 }}</div>
            <div class="text-sm text-gray-600">Total Reviews</div>
            <div class="text-xs text-gray-500 mt-1">Completed</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-green-600 mb-2">{{ $approved ?? 0 }}</div>
            <div class="text-sm text-gray-600">Approved</div>
            <div class="text-xs text-gray-500 mt-1">Documents</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-red-600 mb-2">{{ $rejected ?? 0 }}</div>
            <div class="text-sm text-gray-600">Rejected</div>
            <div class="text-xs text-gray-500 mt-1">Documents</div>
        </div>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
    <!-- Documents Awaiting Action -->
    <div class="card">
        <div class="card-header">
            <div class="flex items-center justify-between">
                <h3 class="text-lg font-bold text-gray-800">Documents Awaiting Review</h3>
                @if(isset($documentsAwaitingAction) && $documentsAwaitingAction->count() > 0)
                    <span class="status-badge status-warning">{{ $documentsAwaitingAction->count() }}</span>
                @endif
            </div>
        </div>
        <div class="card-body">
            @if(isset($documentsAwaitingAction) && $documentsAwaitingAction->count() > 0)
                <div class="space-y-4">
                    @foreach($documentsAwaitingAction as $document)
                        <div class="flex items-center justify-between p-4 bg-orange-50 rounded-lg border-l-4 border-orange-400">
                            <div class="flex-1">
                                <h4 class="font-medium text-gray-900">{{ $document->title }}</h4>
                                <p class="text-sm text-gray-600">{{ $document->type }} • {{ $document->contractor->name }}</p>
                                <p class="text-xs text-gray-500">Submitted {{ $document->created_at->diffForHumans() }}</p>
                            </div>
                            <div class="flex space-x-2">
                                <a href="{{ route('approvals.show', $document) }}" class="btn btn-primary btn-sm">
                                    Review
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="mt-4 text-center">
                    <a href="{{ route('approvals.index') }}" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                        View All Pending Reviews →
                    </a>
                </div>
            @else
                <div class="text-center py-8">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"></path>
                    </svg>
                    <h3 class="mt-2 text-sm font-medium text-gray-900">No pending reviews</h3>
                    <p class="mt-1 text-sm text-gray-500">All documents have been reviewed.</p>
                </div>
            @endif
        </div>
    </div>

    <!-- Approval Ratio Chart -->
    <div class="card">
        <div class="card-header">
            <h3 class="text-lg font-bold text-gray-800">Approval vs Rejection Ratio</h3>
        </div>
        <div class="card-body">
            <canvas id="approvalRatioChart" width="400" height="300"></canvas>
        </div>
    </div>
</div>

<!-- Weekly Approval Trends -->
@if(isset($weeklyApprovals) && $weeklyApprovals->count() > 0)
<div class="card mb-8">
    <div class="card-header">
        <h3 class="text-lg font-bold text-gray-800">Weekly Approval Trends</h3>
    </div>
    <div class="card-body">
        <canvas id="weeklyTrendsChart" width="800" height="300"></canvas>
    </div>
</div>
@endif

<!-- Recent Notifications -->
<div class="card">
    <div class="card-header">
        <h3 class="text-lg font-bold text-gray-800">Recent Notifications</h3>
    </div>
    <div class="card-body">
        @if(isset($recentNotifications) && $recentNotifications->count() > 0)
            <div class="space-y-3">
                @foreach($recentNotifications->take(5) as $notification)
                    <div class="flex items-start space-x-3 p-3 {{ $notification->read_status ? 'bg-gray-50' : 'bg-blue-50' }} rounded-lg">
                        <div class="flex-shrink-0 mt-1">
                            @if(!$notification->read_status)
                                <div class="w-2 h-2 bg-blue-500 rounded-full"></div>
                            @else
                                <div class="w-2 h-2 bg-gray-300 rounded-full"></div>
                            @endif
                        </div>
                        <div class="flex-1">
                            <p class="text-sm text-gray-900">{{ $notification->message }}</p>
                            <p class="text-xs text-gray-500">{{ $notification->created_at->diffForHumans() }}</p>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="mt-4 text-center">
                <a href="{{ route('notifications.index') }}" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                    View All Notifications →
                </a>
            </div>
        @else
            <div class="text-center py-6">
                <p class="text-sm text-gray-500">No recent notifications.</p>
            </div>
        @endif
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Approval Ratio Donut Chart
    const approvalRatioCtx = document.getElementById('approvalRatioChart').getContext('2d');
    new Chart(approvalRatioCtx, {
        type: 'doughnut',
        data: {
            labels: ['Approved', 'Rejected'],
            datasets: [{
                data: [{{ $approved ?? 0 }}, {{ $rejected ?? 0 }}],
                backgroundColor: ['#10B981', '#EF4444'],
                borderWidth: 2,
                borderColor: '#ffffff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true
                    }
                }
            }
        }
    });

    // Weekly Trends Line Chart
    @if(isset($weeklyApprovals) && $weeklyApprovals->count() > 0)
    const weeklyTrendsCtx = document.getElementById('weeklyTrendsChart').getContext('2d');
    new Chart(weeklyTrendsCtx, {
        type: 'line',
        data: {
            labels: [
                @foreach($weeklyApprovals as $week)
                    'Week {{ $week->week }}',
                @endforeach
            ],
            datasets: [{
                label: 'Approved',
                data: [
                    @foreach($weeklyApprovals as $week)
                        {{ $week->approved }},
                    @endforeach
                ],
                borderColor: '#10B981',
                backgroundColor: 'rgba(16, 185, 129, 0.1)',
                tension: 0.4,
                fill: true
            }, {
                label: 'Rejected',
                data: [
                    @foreach($weeklyApprovals as $week)
                        {{ $week->rejected }},
                    @endforeach
                ],
                borderColor: '#EF4444',
                backgroundColor: 'rgba(239, 68, 68, 0.1)',
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            },
            plugins: {
                legend: {
                    position: 'top'
                }
            }
        }
    });
    @endif
});
</script>
