<!-- Contractor Dashboard Statistics -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-blue-600 mb-2">{{ $totalDocuments ?? 0 }}</div>
            <div class="text-sm text-gray-600">Total Documents</div>
            <div class="text-xs text-gray-500 mt-1">Submitted</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-yellow-600 mb-2">{{ $pendingConsultant ?? 0 }}</div>
            <div class="text-sm text-gray-600">Pending Review</div>
            <div class="text-xs text-gray-500 mt-1">Consultant</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-red-600 mb-2">{{ $rejectedDocuments ?? 0 }}</div>
            <div class="text-sm text-gray-600">Rejected</div>
            <div class="text-xs text-gray-500 mt-1">Documents</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-green-600 mb-2">{{ $approvedDocuments ?? 0 }}</div>
            <div class="text-sm text-gray-600">Approved</div>
            <div class="text-xs text-gray-500 mt-1">Final</div>
        </div>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
    <!-- Recent Submissions -->
    <div class="card">
        <div class="card-header">
            <h3 class="text-lg font-bold text-gray-800">Recent Submissions</h3>
        </div>
        <div class="card-body">
            @if(isset($recentSubmissions) && $recentSubmissions->count() > 0)
                <div class="space-y-4">
                    @foreach($recentSubmissions as $document)
                        <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                            <div class="flex-1">
                                <h4 class="font-medium text-gray-900">{{ $document->title }}</h4>
                                <p class="text-sm text-gray-600">{{ $document->type }}</p>
                                <p class="text-xs text-gray-500">{{ $document->created_at->diffForHumans() }}</p>
                            </div>
                            <div class="text-right">
                                <span class="status-badge
                                    @if(str_contains($document->current_status, 'Rejected'))
                                        status-rejected
                                    @elseif($document->current_status === 'Final Approved')
                                        status-approved
                                    @else
                                        status-pending
                                    @endif
                                ">
                                    {{ $document->current_status }}
                                </span>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="mt-4 text-center">
                    <a href="{{ route('documents.index') }}" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                        View All Documents →
                    </a>
                </div>
            @else
                <div class="text-center py-8">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    <h3 class="mt-2 text-sm font-medium text-gray-900">No documents yet</h3>
                    <p class="mt-1 text-sm text-gray-500">Start by uploading your first document.</p>
                    <div class="mt-4">
                        <a href="{{ route('documents.create') }}" class="btn btn-primary">
                            Upload Document
                        </a>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Document Categories Chart -->
    <div class="card">
        <div class="card-header">
            <h3 class="text-lg font-bold text-gray-800">Document Categories</h3>
        </div>
        <div class="card-body">
            <canvas id="categoriesChart" width="400" height="300"></canvas>
        </div>
    </div>
</div>

<!-- Document Status Distribution -->
<div class="card mb-8">
    <div class="card-header">
        <h3 class="text-lg font-bold text-gray-800">Status Distribution</h3>
    </div>
    <div class="card-body">
        <canvas id="statusChart" width="800" height="300"></canvas>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Document Categories Pie Chart
    @if(isset($documentCategories) && $documentCategories->count() > 0)
    const categoriesCtx = document.getElementById('categoriesChart').getContext('2d');
    new Chart(categoriesCtx, {
        type: 'doughnut',
        data: {
            labels: [
                @foreach($documentCategories as $category)
                    '{{ $category->type }}',
                @endforeach
            ],
            datasets: [{
                data: [
                    @foreach($documentCategories as $category)
                        {{ $category->count }},
                    @endforeach
                ],
                backgroundColor: [
                    '#3B82F6', '#10B981', '#F59E0B', '#EF4444', '#8B5CF6'
                ],
                borderWidth: 2,
                borderColor: '#ffffff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true
                    }
                }
            }
        }
    });
    @endif

    // Status Distribution Bar Chart
    @if(isset($statusDistribution) && $statusDistribution->count() > 0)
    const statusCtx = document.getElementById('statusChart').getContext('2d');
    new Chart(statusCtx, {
        type: 'bar',
        data: {
            labels: [
                @foreach($statusDistribution as $status)
                    '{{ $status->current_status }}',
                @endforeach
            ],
            datasets: [{
                label: 'Documents',
                data: [
                    @foreach($statusDistribution as $status)
                        {{ $status->count }},
                    @endforeach
                ],
                backgroundColor: [
                    @foreach($statusDistribution as $status)
                        @if(str_contains($status->current_status, 'Rejected'))
                            '#EF4444',
                        @elseif($status->current_status === 'Final Approved')
                            '#10B981',
                        @else
                            '#F59E0B',
                        @endif
                    @endforeach
                ],
                borderColor: [
                    @foreach($statusDistribution as $status)
                        @if(str_contains($status->current_status, 'Rejected'))
                            '#DC2626',
                        @elseif($status->current_status === 'Final Approved')
                            '#059669',
                        @else
                            '#D97706',
                        @endif
                    @endforeach
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            },
            plugins: {
                legend: {
                    display: false
                }
            }
        }
    });
    @endif
});
</script>
