<!-- Default Dashboard for users without specific roles -->
<div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-blue-600 mb-2">{{ $totalUsers ?? 0 }}</div>
            <div class="text-sm text-gray-600">Total Users</div>
            <div class="text-xs text-gray-500 mt-1">In System</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-green-600 mb-2">{{ $totalDocuments ?? 0 }}</div>
            <div class="text-sm text-gray-600">Total Documents</div>
            <div class="text-xs text-gray-500 mt-1">Submitted</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-purple-600 mb-2">{{ $totalApprovals ?? 0 }}</div>
            <div class="text-sm text-gray-600">Total Approvals</div>
            <div class="text-xs text-gray-500 mt-1">Processed</div>
        </div>
    </div>
</div>

<!-- Role Assignment Notice -->
<div class="card mb-8">
    <div class="card-body">
        <div class="flex items-start space-x-3">
            <div class="flex-shrink-0">
                <svg class="h-6 w-6 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
            </div>
            <div>
                <h3 class="text-sm font-medium text-gray-900">Role Assignment Required</h3>
                <div class="mt-2 text-sm text-gray-600">
                    <p>You don't have a specific role assigned yet. Contact an administrator to assign you one of the following roles:</p>
                    <ul class="mt-2 list-disc list-inside space-y-1">
                        <li><strong>Contractor:</strong> Upload and manage your own documents</li>
                        <li><strong>Consultant:</strong> Review contractor-submitted documents</li>
                        <li><strong>Client A:</strong> Review consultant-approved documents</li>
                        <li><strong>Client B/C:</strong> Final review stage with rejection rights</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Notifications -->
<div class="card">
    <div class="card-header">
        <div class="flex items-center justify-between">
            <h3 class="text-lg font-bold text-gray-800">Recent Notifications</h3>
            @if(isset($recentNotifications) && $recentNotifications->where('read_status', false)->count() > 0)
                <span class="status-badge status-pending">
                    {{ $recentNotifications->where('read_status', false)->count() }} unread
                </span>
            @endif
        </div>
    </div>
    <div class="card-body">
        @if(isset($recentNotifications) && $recentNotifications->count() > 0)
            <div class="space-y-4">
                @foreach($recentNotifications as $notification)
                    <div class="flex items-start space-x-4 p-4 {{ $notification->read_status ? 'bg-gray-50' : 'bg-blue-50' }} rounded-lg border-l-4 {{ $notification->read_status ? 'border-gray-300' : 'border-blue-400' }} transition-all duration-200 hover:shadow-md">
                        <div class="flex-shrink-0 mt-1">
                            @if(!$notification->read_status)
                                <div class="w-3 h-3 bg-blue-500 rounded-full animate-pulse"></div>
                            @else
                                <div class="w-3 h-3 bg-gray-300 rounded-full"></div>
                            @endif
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-sm font-medium text-gray-900">{{ $notification->message }}</p>
                            <div class="mt-1 flex items-center text-xs text-gray-500">
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                {{ $notification->created_at->diffForHumans() }}
                            </div>
                        </div>
                        @if($notification->document)
                            <div class="flex-shrink-0">
                                <a href="{{ route('documents.show', $notification->document) }}" class="text-blue-600 hover:text-blue-800 text-xs font-medium">
                                    View Document
                                </a>
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
            <div class="mt-6 text-center">
                <a href="{{ route('notifications.index') }}" class="btn btn-primary">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-5 5v-5z"></path>
                    </svg>
                    View All Notifications
                </a>
            </div>
        @else
            <div class="text-center py-8">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-5 5v-5zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2z"></path>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">No notifications</h3>
                <p class="mt-1 text-sm text-gray-500">You'll see notifications here once you have a role assigned.</p>
            </div>
        @endif
    </div>
</div>
