<!-- SuperAdmin Dashboard -->
<div class="mb-8">
    <div class="alert alert-info">
        <svg class="w-5 h-5 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.5-1.5a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
        </svg>
        <strong>SuperAdmin Access:</strong> You have full system access and can manage all users, documents, and system settings.
    </div>
</div>

<!-- System Overview Statistics -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-blue-600 mb-2">{{ $totalUsers ?? 0 }}</div>
            <div class="text-sm text-gray-600">Total Users</div>
            <div class="text-xs text-gray-500 mt-1">System Wide</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-green-600 mb-2">{{ $totalDocuments ?? 0 }}</div>
            <div class="text-sm text-gray-600">Total Documents</div>
            <div class="text-xs text-gray-500 mt-1">All Submissions</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-purple-600 mb-2">{{ $totalApprovals ?? 0 }}</div>
            <div class="text-sm text-gray-600">Total Approvals</div>
            <div class="text-xs text-gray-500 mt-1">All Reviews</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-indigo-600 mb-2">{{ $totalNotifications ?? 0 }}</div>
            <div class="text-sm text-gray-600">Notifications</div>
            <div class="text-xs text-gray-500 mt-1">System Wide</div>
        </div>
    </div>
</div>

<!-- Admin Quick Actions -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <a href="{{ route('users.create') }}" class="group relative overflow-hidden rounded-xl bg-gradient-to-r from-emerald-400 to-emerald-600 p-6 text-white shadow-lg hover:shadow-xl transform hover:-translate-y-1 transition-all duration-300">
        <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <div class="p-2 bg-white bg-opacity-20 rounded-lg">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                </div>
            </div>
            <h3 class="text-lg font-bold mb-2">Create User</h3>
            <p class="text-emerald-100 text-sm">Add new users to the system</p>
        </div>
        <div class="absolute inset-0 bg-gradient-to-r from-emerald-600 to-emerald-400 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
    </a>

    <a href="{{ route('users.index') }}" class="group relative overflow-hidden rounded-xl bg-gradient-to-r from-cyan-400 to-cyan-600 p-6 text-white shadow-lg hover:shadow-xl transform hover:-translate-y-1 transition-all duration-300">
        <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <div class="p-2 bg-white bg-opacity-20 rounded-lg">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                    </svg>
                </div>
                @if(isset($usersWithoutRoles) && $usersWithoutRoles > 0)
                    <span class="bg-red-500 text-white text-xs rounded-full h-6 w-6 flex items-center justify-center font-bold">
                        {{ $usersWithoutRoles }}
                    </span>
                @endif
            </div>
            <h3 class="text-lg font-bold mb-2">Manage Users</h3>
            <p class="text-cyan-100 text-sm">Assign roles and manage users</p>
        </div>
        <div class="absolute inset-0 bg-gradient-to-r from-cyan-600 to-cyan-400 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
    </a>

    <a href="{{ route('documents.index') }}" class="group relative overflow-hidden rounded-xl bg-gradient-to-r from-violet-400 to-violet-600 p-6 text-white shadow-lg hover:shadow-xl transform hover:-translate-y-1 transition-all duration-300">
        <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <div class="p-2 bg-white bg-opacity-20 rounded-lg">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
            </div>
            <h3 class="text-lg font-bold mb-2">All Documents</h3>
            <p class="text-violet-100 text-sm">View and manage all documents</p>
        </div>
        <div class="absolute inset-0 bg-gradient-to-r from-violet-600 to-violet-400 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
    </a>

    <a href="{{ route('approvals.index') }}" class="group relative overflow-hidden rounded-xl bg-gradient-to-r from-rose-400 to-rose-600 p-6 text-white shadow-lg hover:shadow-xl transform hover:-translate-y-1 transition-all duration-300">
        <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <div class="p-2 bg-white bg-opacity-20 rounded-lg">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"></path>
                    </svg>
                </div>
            </div>
            <h3 class="text-lg font-bold mb-2">System Analytics</h3>
            <p class="text-rose-100 text-sm">View approval analytics</p>
        </div>
        <div class="absolute inset-0 bg-gradient-to-r from-rose-600 to-rose-400 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
    </a>
</div>

<!-- Charts Row 1 -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
    <!-- Users by Role -->
    <div class="card">
        <div class="card-header">
            <h3 class="text-lg font-bold text-gray-800">Users by Role</h3>
        </div>
        <div class="card-body">
            <canvas id="usersByRoleChart" width="400" height="300"></canvas>
        </div>
    </div>

    <!-- Document Types Distribution -->
    <div class="card">
        <div class="card-header">
            <h3 class="text-lg font-bold text-gray-800">Document Types</h3>
        </div>
        <div class="card-body">
            <canvas id="documentTypesChart" width="400" height="300"></canvas>
        </div>
    </div>
</div>

<!-- Charts Row 2 -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
    <!-- Workflow Funnel -->
    <div class="card">
        <div class="card-header">
            <h3 class="text-lg font-bold text-gray-800">Approval Workflow Funnel</h3>
        </div>
        <div class="card-body">
            <canvas id="workflowFunnelChart" width="400" height="300"></canvas>
        </div>
    </div>

    <!-- Document Status Distribution -->
    <div class="card">
        <div class="card-header">
            <h3 class="text-lg font-bold text-gray-800">Document Status Distribution</h3>
        </div>
        <div class="card-body">
            <canvas id="documentStatusChart" width="400" height="300"></canvas>
        </div>
    </div>
</div>

<!-- Monthly Document Trends -->
@if(isset($monthlyDocuments) && $monthlyDocuments->count() > 0)
<div class="card mb-8">
    <div class="card-header">
        <h3 class="text-lg font-bold text-gray-800">Monthly Document Submission Trends</h3>
    </div>
    <div class="card-body">
        <canvas id="monthlyDocumentChart" width="800" height="300"></canvas>
    </div>
</div>
@endif

<!-- System Analytics Tables -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
    <!-- Recent Documents -->
    <div class="card">
        <div class="card-header">
            <h3 class="text-lg font-bold text-gray-800">Recent Documents</h3>
        </div>
        <div class="card-body">
            @if(isset($recentDocuments) && $recentDocuments->count() > 0)
                <div class="space-y-3">
                    @foreach($recentDocuments as $document)
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex-1">
                                <h4 class="font-medium text-gray-900">{{ $document->title }}</h4>
                                <p class="text-sm text-gray-600">{{ $document->type }} • {{ $document->contractor->name }}</p>
                                <p class="text-xs text-gray-500">{{ $document->created_at->diffForHumans() }}</p>
                            </div>
                            <div>
                                <span class="status-badge
                                    @if(str_contains($document->current_status, 'Rejected'))
                                        status-rejected
                                    @elseif($document->current_status === 'Final Approved')
                                        status-approved
                                    @else
                                        status-pending
                                    @endif
                                ">
                                    {{ $document->current_status }}
                                </span>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-6">
                    <p class="text-sm text-gray-500">No documents in the system yet.</p>
                </div>
            @endif
        </div>
    </div>

    <!-- Average Approval Times -->
    <div class="card">
        <div class="card-header">
            <h3 class="text-lg font-bold text-gray-800">Average Approval Times</h3>
        </div>
        <div class="card-body">
            @if(isset($averageApprovalTimes) && $averageApprovalTimes->count() > 0)
                <div class="space-y-4">
                    @foreach($averageApprovalTimes as $timeData)
                        <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                            <div class="flex items-center">
                                <div class="w-4 h-4 bg-blue-500 rounded-full mr-3"></div>
                                <span class="font-medium text-gray-900">{{ $timeData->role }}</span>
                            </div>
                            <div class="text-right">
                                <div class="text-lg font-bold text-blue-600">
                                    {{ number_format($timeData->avg_days, 1) }}
                                </div>
                                <div class="text-xs text-gray-500">days avg</div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-6">
                    <svg class="mx-auto h-8 w-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <p class="text-sm text-gray-500 mt-2">No approval time data available yet.</p>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- System Health Alerts -->
@if(isset($usersWithoutRoles) && $usersWithoutRoles > 0)
<div class="card mb-8">
    <div class="card-body">
        <div class="flex items-start space-x-3">
            <div class="flex-shrink-0">
                <svg class="h-6 w-6 text-amber-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                </svg>
            </div>
            <div class="flex-1">
                <h3 class="text-sm font-medium text-gray-900">System Alert</h3>
                <p class="mt-1 text-sm text-gray-600">
                    <strong>{{ $usersWithoutRoles }}</strong> user(s) don't have roles assigned.
                    <a href="{{ route('users.index') }}" class="text-blue-600 hover:text-blue-800 font-medium">Assign roles now →</a>
                </p>
            </div>
        </div>
    </div>
</div>
@endif

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Users by Role Pie Chart
    @if(isset($usersByRole) && $usersByRole->count() > 0)
    const usersByRoleCtx = document.getElementById('usersByRoleChart').getContext('2d');
    new Chart(usersByRoleCtx, {
        type: 'doughnut',
        data: {
            labels: [
                @foreach($usersByRole as $roleData)
                    '{{ $roleData->role_name }}',
                @endforeach
            ],
            datasets: [{
                data: [
                    @foreach($usersByRole as $roleData)
                        {{ $roleData->count }},
                    @endforeach
                ],
                backgroundColor: [
                    '#3B82F6', '#10B981', '#F59E0B', '#EF4444', '#8B5CF6', '#06B6D4'
                ],
                borderWidth: 2,
                borderColor: '#ffffff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true
                    }
                }
            }
        }
    });
    @endif

    // Document Types Chart
    @if(isset($documentsByType) && $documentsByType->count() > 0)
    const documentTypesCtx = document.getElementById('documentTypesChart').getContext('2d');
    new Chart(documentTypesCtx, {
        type: 'doughnut',
        data: {
            labels: [
                @foreach($documentsByType as $typeData)
                    '{{ $typeData->type }}',
                @endforeach
            ],
            datasets: [{
                data: [
                    @foreach($documentsByType as $typeData)
                        {{ $typeData->count }},
                    @endforeach
                ],
                backgroundColor: [
                    '#3B82F6', '#10B981', '#F59E0B', '#EF4444', '#8B5CF6'
                ],
                borderWidth: 2,
                borderColor: '#ffffff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true
                    }
                }
            }
        }
    });
    @endif

    // Workflow Funnel Chart
    @if(isset($workflowFunnel))
    const workflowFunnelCtx = document.getElementById('workflowFunnelChart').getContext('2d');
    new Chart(workflowFunnelCtx, {
        type: 'bar',
        data: {
            labels: ['Submitted', 'Consultant Approved', 'Client A Approved', 'Final Approved'],
            datasets: [{
                label: 'Documents',
                data: [
                    {{ $workflowFunnel['submitted'] }},
                    {{ $workflowFunnel['consultant_approved'] }},
                    {{ $workflowFunnel['client_a_approved'] }},
                    {{ $workflowFunnel['final_approved'] }}
                ],
                backgroundColor: [
                    '#3B82F6', '#10B981', '#F59E0B', '#8B5CF6'
                ],
                borderColor: [
                    '#2563EB', '#059669', '#D97706', '#7C3AED'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            },
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    callbacks: {
                        afterLabel: function(context) {
                            const total = {{ $workflowFunnel['submitted'] }};
                            const percentage = total > 0 ? ((context.parsed.y / total) * 100).toFixed(1) : 0;
                            return percentage + '% of total submissions';
                        }
                    }
                }
            }
        }
    });
    @endif

    // Document Status Distribution
    @if(isset($documentsByStatus) && $documentsByStatus->count() > 0)
    const documentStatusCtx = document.getElementById('documentStatusChart').getContext('2d');
    new Chart(documentStatusCtx, {
        type: 'bar',
        data: {
            labels: [
                @foreach($documentsByStatus as $statusData)
                    '{{ $statusData->current_status }}',
                @endforeach
            ],
            datasets: [{
                label: 'Documents',
                data: [
                    @foreach($documentsByStatus as $statusData)
                        {{ $statusData->count }},
                    @endforeach
                ],
                backgroundColor: [
                    @foreach($documentsByStatus as $statusData)
                        @if(str_contains($statusData->current_status, 'Rejected'))
                            '#EF4444',
                        @elseif($statusData->current_status === 'Final Approved')
                            '#10B981',
                        @else
                            '#F59E0B',
                        @endif
                    @endforeach
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            },
            plugins: {
                legend: {
                    display: false
                }
            }
        }
    });
    @endif

    // Monthly Document Trends
    @if(isset($monthlyDocuments) && $monthlyDocuments->count() > 0)
    const monthlyDocumentCtx = document.getElementById('monthlyDocumentChart').getContext('2d');
    new Chart(monthlyDocumentCtx, {
        type: 'line',
        data: {
            labels: [
                @foreach($monthlyDocuments as $monthData)
                    '{{ date("M Y", mktime(0, 0, 0, $monthData->month, 1, $monthData->year)) }}',
                @endforeach
            ],
            datasets: [{
                label: 'Documents Submitted',
                data: [
                    @foreach($monthlyDocuments as $monthData)
                        {{ $monthData->count }},
                    @endforeach
                ],
                borderColor: '#3B82F6',
                backgroundColor: 'rgba(59, 130, 246, 0.1)',
                tension: 0.4,
                fill: true,
                pointBackgroundColor: '#3B82F6',
                pointBorderColor: '#2563EB',
                pointBorderWidth: 2,
                pointRadius: 6
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            },
            plugins: {
                legend: {
                    position: 'top'
                }
            }
        }
    });
    @endif
});
</script>
