<x-app-layout>
    <x-slot name="header">
        <div class="page-header">
            <div class="flex justify-between items-center">
                <div>
                    <h2 class="font-bold text-2xl mb-2">
                        @if(Auth::user()->hasRole('Contractor'))
                            📂 My Documents
                        @elseif(Auth::user()->hasRole('SuperAdmin'))
                            🗂️ All Documents - Admin View
                        @else
                            📋 Document Library
                        @endif
                    </h2>
                    <p class="text-blue-100">
                        @if(Auth::user()->hasRole('Contractor'))
                            Manage and track your submitted documents
                        @elseif(Auth::user()->hasRole('SuperAdmin'))
                            Complete system overview of all documents
                        @else
                            Browse and review construction documents
                        @endif
                    </p>
                </div>
                @if(Auth::user()->hasRole('Contractor'))
                    <a href="{{ route('documents.create') }}" class="btn btn-white btn-lg hover-glow animate-scale-in">
                        <svg class="w-5 h-5 mr-2 animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        <span class="font-bold">Upload Document</span>
                    </a>
                @endif
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="alert alert-success animate-fade-in">
                    <svg class="w-5 h-5 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    {{ session('success') }}
                </div>
            @endif

            <div class="card animate-scale-in">
                <div class="p-6 bg-white border-b border-gray-200">
                    @if($documents->count() > 0)
                        <div class="overflow-x-auto animate-fade-in animate-stagger-2">
                            <table class="min-w-full table-auto">
                                <thead>
                                    <tr class="bg-gray-50 animate-slide-down">
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider animate-fade-in animate-stagger-1">Title</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider animate-fade-in animate-stagger-2">Type</th>
                                        @if(!Auth::user()->hasRole('Contractor'))
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider animate-fade-in animate-stagger-3">Contractor</th>
                                        @endif
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider animate-fade-in animate-stagger-4">Status</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider animate-fade-in animate-stagger-5">Version</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider animate-fade-in animate-stagger-6">Uploaded</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider animate-fade-in animate-stagger-6">Actions</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @foreach($documents as $document)
                                        <tr class="hover:bg-gray-50 transition-colors duration-200 animate-slide-up animate-stagger-{{ $loop->index % 6 + 1 }} hover-lift">
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm font-medium text-gray-900 hover-scale">{{ $document->title }}</div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">
                                                    {{ $document->type }}
                                                </span>
                                            </td>
                                            @if(!Auth::user()->hasRole('Contractor'))
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                                    {{ $document->contractor->name }}
                                                </td>
                                            @endif
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                                                    @if(str_contains($document->current_status, 'Rejected'))
                                                        bg-red-100 text-red-800
                                                    @elseif($document->current_status === 'Final Approved')
                                                        bg-green-100 text-green-800
                                                    @else
                                                        bg-yellow-100 text-yellow-800
                                                    @endif
                                                ">
                                                    {{ $document->current_status }}
                                                </span>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                                v{{ $document->versions->max('version_number') ?? 1 }}
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                                {{ $document->created_at->format('M d, Y') }}
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                                                <a href="{{ route('documents.show', $document) }}" class="text-indigo-600 hover:text-indigo-900 hover-scale transition-all duration-200">View</a>
                                                <a href="{{ route('documents.download', $document) }}" class="text-green-600 hover:text-green-900 hover-scale transition-all duration-200">Download</a>
                                                @if(Auth::user()->hasRole('Contractor') && $document->contractor_id === Auth::id())
                                                    <a href="{{ route('documents.history', $document) }}" class="text-blue-600 hover:text-blue-900 hover-scale transition-all duration-200">History</a>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-8">
                            <p class="text-gray-500 text-lg">
                                @if(Auth::user()->hasRole('Contractor'))
                                    You haven't uploaded any documents yet.
                                @else
                                    No documents found in the system.
                                @endif
                            </p>
                            @if(Auth::user()->hasRole('Contractor'))
                                <a href="{{ route('documents.create') }}" class="mt-4 bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded inline-block">
                                    Upload Your First Document
                                </a>
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
