<x-app-layout>
    <x-slot name="header">
        <div class="page-header">
            <div class="flex justify-between items-center">
                <div class="flex items-center">
                    <svg class="w-8 h-8 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-5 5v-5zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2z"></path>
                    </svg>
                    <div>
                        <h2 class="font-bold text-2xl mb-1">🔔 Notifications</h2>
                        <p class="text-blue-100">Stay updated with system activities and alerts</p>
                    </div>
                </div>
                @if($notifications->where('read_status', false)->count() > 0)
                    <button onclick="markAllAsRead()" class="btn bg-white text-blue-600 hover:bg-blue-50 font-semibold">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Mark All as Read
                    </button>
                @endif
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="card animate-fade-in">
                <div class="card-header">
                    <div class="flex items-center justify-between">
                        <h3 class="text-lg font-bold text-gray-800">Your Notifications</h3>
                        @if($notifications->where('read_status', false)->count() > 0)
                            <span class="status-badge status-pending">
                                {{ $notifications->where('read_status', false)->count() }} unread
                            </span>
                        @endif
                    </div>
                </div>
                <div class="card-body p-0">
                    @if($notifications->count() > 0)
                        <div class="divide-y divide-gray-200">
                            @foreach($notifications as $notification)
                                <div class="notification-item p-6 {{ $notification->read_status ? 'bg-white' : 'bg-blue-50' }} hover:bg-gray-50 transition-all duration-300 animate-slide-up animate-stagger-{{ $loop->index % 6 + 1 }} hover-lift"
                                     data-id="{{ $notification->id }}">
                                    <div class="flex items-start space-x-4">
                                        <div class="flex-shrink-0 mt-1">
                                            @if(!$notification->read_status)
                                                <div class="w-3 h-3 bg-blue-500 rounded-full animate-pulse hover-glow"></div>
                                            @else
                                                <div class="w-3 h-3 bg-gray-300 rounded-full animate-fade-in"></div>
                                            @endif
                                        </div>
                                        <div class="flex-1 min-w-0">
                                            <div class="flex items-start justify-between">
                                                <div class="flex-1">
                                                    <p class="text-sm {{ $notification->read_status ? 'text-gray-700' : 'text-gray-900 font-medium' }}">
                                                        {{ $notification->message }}
                                                    </p>
                                                    <div class="mt-2 flex items-center text-xs text-gray-500 space-x-4">
                                                        <div class="flex items-center">
                                                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                            </svg>
                                                            {{ $notification->created_at->diffForHumans() }}
                                                        </div>
                                                        <div class="text-gray-300">•</div>
                                                        <div>{{ $notification->created_at->format('M d, Y \a\t g:i A') }}</div>
                                                    </div>
                                                </div>
                                                <div class="flex items-center space-x-2 ml-4">
                                                    @if($notification->document)
                                                        <a href="{{ route('documents.show', $notification->document) }}"
                                                           class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                                                            View Document
                                                        </a>
                                                    @endif
                                                    @if(!$notification->read_status)
                                                        <button onclick="markAsRead({{ $notification->id }})"
                                                                class="text-gray-400 hover:text-gray-600 text-sm">
                                                            Mark as read
                                                        </button>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <!-- Pagination -->
                        @if($notifications->hasPages())
                            <div class="p-6 border-t border-gray-200">
                                {{ $notifications->links() }}
                            </div>
                        @endif
                    @else
                        <div class="text-center py-12">
                            <svg class="mx-auto h-16 w-16 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-5 5v-5zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2z"></path>
                            </svg>
                            <h3 class="mt-4 text-lg font-medium text-gray-900">No notifications</h3>
                            <p class="mt-2 text-sm text-gray-500">You're all caught up! No new notifications at this time.</p>
                            <div class="mt-6">
                                <a href="{{ route('dashboard') }}" class="btn btn-primary">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z"></path>
                                    </svg>
                                    Go to Dashboard
                                </a>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <script>
        function markAsRead(notificationId) {
            fetch(`/notifications/${notificationId}/mark-read`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    const notificationItem = document.querySelector(`[data-id="${notificationId}"]`);
                    notificationItem.classList.remove('bg-blue-50');
                    notificationItem.classList.add('bg-white');

                    // Update the notification indicator
                    const indicator = notificationItem.querySelector('.w-3.h-3');
                    indicator.classList.remove('bg-blue-500', 'animate-pulse');
                    indicator.classList.add('bg-gray-300');

                    // Remove the mark as read button
                    const markButton = notificationItem.querySelector('button');
                    if (markButton) markButton.remove();

                    // Update message styling
                    const message = notificationItem.querySelector('p');
                    message.classList.remove('font-medium', 'text-gray-900');
                    message.classList.add('text-gray-700');

                    // Reload page to update counters
                    setTimeout(() => window.location.reload(), 1000);
                }
            })
            .catch(error => console.error('Error:', error));
        }

        function markAllAsRead() {
            fetch('/notifications/mark-all-read', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    window.location.reload();
                }
            })
            .catch(error => console.error('Error:', error));
        }
    </script>
</x-app-layout>
