<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                Assign Role to {{ $user->name }}
            </h2>
            <a href="{{ route('users.index') }}" class="btn btn-secondary">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                </svg>
                Back to Users
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-2xl mx-auto sm:px-6 lg:px-8">
            @if($errors->any())
                <div class="alert alert-error animate-fade-in">
                    <svg class="w-5 h-5 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <strong>Please fix the following errors:</strong>
                    <ul class="list-disc list-inside mt-2">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="card animate-fade-in">
                <div class="card-header">
                    <h3 class="text-lg font-bold text-gray-800">User Information</h3>
                </div>
                <div class="card-body">
                    <div class="flex items-center space-x-4 mb-6">
                        <div class="flex-shrink-0 h-16 w-16">
                            <div class="h-16 w-16 rounded-full bg-blue-500 flex items-center justify-center">
                                <span class="text-white font-bold text-xl">
                                    {{ substr($user->name, 0, 2) }}
                                </span>
                            </div>
                        </div>
                        <div>
                            <h4 class="text-xl font-semibold text-gray-900">{{ $user->name }}</h4>
                            <p class="text-gray-600">{{ $user->email }}</p>
                            <p class="text-sm text-gray-500">Member since {{ $user->created_at->format('M d, Y') }}</p>
                        </div>
                    </div>

                    <div class="mb-6">
                        <label class="form-label">Current Role</label>
                        @if($user->roles->count() > 0)
                            <span class="status-badge status-final">
                                {{ $user->roles->first()->name }}
                            </span>
                        @else
                            <span class="status-badge bg-gray-100 text-gray-800">No Role Assigned</span>
                        @endif
                    </div>

                    <form action="{{ route('users.assign-role.store', $user) }}" method="POST" class="space-y-6">
                        @csrf

                        <div>
                            <label for="role" class="form-label">
                                <svg class="w-4 h-4 mr-1 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.5-1.5a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                                </svg>
                                Select New Role
                            </label>
                            <select name="role" id="role" required class="form-select">
                                <option value="">Choose a role</option>
                                @foreach($roles as $role)
                                    <option value="{{ $role->name }}" {{ old('role') === $role->name ? 'selected' : '' }}>
                                        {{ $role->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Role Descriptions -->
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h5 class="font-semibold text-gray-800 mb-3">Role Descriptions</h5>
                            <div class="space-y-2 text-sm text-gray-600">
                                <div><strong>Contractor:</strong> Can upload and manage their own documents</div>
                                <div><strong>Consultant:</strong> Reviews contractor-submitted documents</div>
                                <div><strong>Client A:</strong> Reviews consultant-approved documents</div>
                                <div><strong>Client B:</strong> Final review stage with rejection rights</div>
                                <div><strong>Client C:</strong> Final review stage with rejection rights</div>
                            </div>
                        </div>

                        <div class="flex items-center justify-between pt-6 border-t border-gray-200">
                            <a href="{{ route('users.index') }}" class="btn btn-secondary">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                                </svg>
                                Cancel
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                Assign Role
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
