<x-app-layout>
    <x-slot name="header">
        <div class="page-header">
            <div class="flex justify-between items-center">
                <div class="flex items-center">
                    <svg class="w-8 h-8 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                    <div>
                        <h2 class="font-bold text-2xl mb-1">➕ Create New User</h2>
                        <p class="text-blue-100">Add a new team member to ConstructFlow</p>
                    </div>
                </div>
                <a href="{{ route('users.index') }}" class="btn bg-white text-blue-600 hover:bg-blue-50 font-semibold">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                    Back to Users
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-2xl mx-auto sm:px-6 lg:px-8">
            @if($errors->any())
                <div class="alert alert-error animate-fade-in">
                    <svg class="w-5 h-5 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <strong>Please fix the following errors:</strong>
                    <ul class="list-disc list-inside mt-2">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="card animate-fade-in">
                <div class="card-header">
                    <h3 class="text-lg font-bold text-gray-800">User Information</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('users.store') }}" method="POST" class="space-y-6">
                        @csrf

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="name" class="form-label">
                                    <svg class="w-4 h-4 mr-1 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                    </svg>
                                    Full Name
                                </label>
                                <input type="text" name="name" id="name" value="{{ old('name') }}" required
                                    placeholder="Enter user's full name"
                                    class="form-input">
                            </div>

                            <div>
                                <label for="email" class="form-label">
                                    <svg class="w-4 h-4 mr-1 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207"></path>
                                    </svg>
                                    Email Address
                                </label>
                                <input type="email" name="email" id="email" value="{{ old('email') }}" required
                                    placeholder="Enter user's email address"
                                    class="form-input">
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="password" class="form-label">
                                    <svg class="w-4 h-4 mr-1 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                                    </svg>
                                    Password
                                </label>
                                <input type="password" name="password" id="password" required
                                    placeholder="Enter a secure password (min 8 characters)"
                                    class="form-input">
                            </div>

                            <div>
                                <label for="password_confirmation" class="form-label">
                                    <svg class="w-4 h-4 mr-1 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    Confirm Password
                                </label>
                                <input type="password" name="password_confirmation" id="password_confirmation" required
                                    placeholder="Confirm the password"
                                    class="form-input">
                            </div>
                        </div>

                        <div>
                            <label for="role" class="form-label">
                                <svg class="w-4 h-4 mr-1 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.5-1.5a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                                </svg>
                                Assign Role
                            </label>
                            <select name="role" id="role" required class="form-select">
                                <option value="">Select a role for this user</option>
                                @foreach($roles as $role)
                                    <option value="{{ $role->name }}" {{ old('role') === $role->name ? 'selected' : '' }}>
                                        @if($role->name === 'SuperAdmin')
                                            👑 {{ $role->name }}
                                        @elseif($role->name === 'Contractor')
                                            🏗️ {{ $role->name }}
                                        @elseif($role->name === 'Consultant')
                                            👨‍💼 {{ $role->name }}
                                        @elseif($role->name === 'ClientA')
                                            🏢 {{ $role->name }}
                                        @elseif($role->name === 'ClientB')
                                            🏛️ {{ $role->name }}
                                        @elseif($role->name === 'ClientC')
                                            🏦 {{ $role->name }}
                                        @else
                                            {{ $role->name }}
                                        @endif
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Role Descriptions -->
                        <div class="bg-gray-50 p-6 rounded-lg">
                            <h5 class="font-semibold text-gray-800 mb-4">Role Descriptions</h5>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm text-gray-600">
                                <div class="space-y-2">
                                    <div><strong>👑 SuperAdmin:</strong> Full system access, can create/delete users, view all analytics</div>
                                    <div><strong>🏗️ Contractor:</strong> Upload and manage their own documents</div>
                                    <div><strong>👨‍💼 Consultant:</strong> Review contractor-submitted documents</div>
                                </div>
                                <div class="space-y-2">
                                    <div><strong>🏢 Client A:</strong> Review consultant-approved documents</div>
                                    <div><strong>🏛️ Client B:</strong> Final review stage with rejection rights</div>
                                    <div><strong>🏦 Client C:</strong> Final review stage with rejection rights</div>
                                </div>
                            </div>
                        </div>

                        <div class="flex items-center justify-between pt-6 border-t border-gray-200">
                            <a href="{{ route('users.index') }}" class="btn btn-secondary">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                                </svg>
                                Cancel
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                                </svg>
                                Create User
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
