<?php

use App\Http\Controllers\DocumentController;
use App\Http\Controllers\ApprovalController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\DashboardController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', [DashboardController::class, 'index'])->middleware(['auth'])->name('dashboard');

// Document Management Routes
Route::middleware(['auth'])->group(function () {
    // Document routes
    Route::resource('documents', DocumentController::class);
    Route::get('documents/{document}/history', [DocumentController::class, 'history'])->name('documents.history');
    Route::post('documents/{document}/upload-version', [DocumentController::class, 'uploadVersion'])->name('documents.upload-version');
    Route::get('documents/{document}/download/{version?}', [DocumentController::class, 'download'])->name('documents.download');

    // Approval routes
    Route::get('approvals', [ApprovalController::class, 'index'])->name('approvals.index');
    Route::get('approvals/{document}', [ApprovalController::class, 'show'])->name('approvals.show');
    Route::post('approvals/{document}/process', [ApprovalController::class, 'process'])->name('approvals.process');

    // Notification routes
    Route::get('notifications', [NotificationController::class, 'index'])->name('notifications.index');
    Route::post('notifications/{notification}/mark-read', [NotificationController::class, 'markAsRead'])->name('notifications.mark-read');
    Route::post('notifications/mark-all-read', [NotificationController::class, 'markAllAsRead'])->name('notifications.mark-all-read');

    // User management routes (for admins)
    Route::get('users', [UserController::class, 'index'])->name('users.index');
    Route::get('users/create', [UserController::class, 'create'])->name('users.create');
    Route::post('users', [UserController::class, 'store'])->name('users.store');
    Route::get('users/{user}/assign-role', [UserController::class, 'showAssignRole'])->name('users.assign-role');
    Route::post('users/{user}/assign-role', [UserController::class, 'assignRole'])->name('users.assign-role.store');
    Route::delete('users/{user}', [UserController::class, 'destroy'])->name('users.destroy');

    // Dashboard API routes for charts
    Route::get('api/workflow-funnel', [DashboardController::class, 'getWorkflowFunnel'])->name('api.workflow-funnel');
    Route::get('api/approval-times', [DashboardController::class, 'getApprovalTimes'])->name('api.approval-times');
});

require __DIR__.'/auth.php';
