<?php if (isset($component)) { $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\AppLayout::class, []); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="page-header">
            <div class="flex justify-between items-center">
                <div>
                    <h2 class="font-bold text-2xl mb-2">
                        <?php if(Auth::user()->hasRole('Contractor')): ?>
                            📂 My Documents
                        <?php elseif(Auth::user()->hasRole('SuperAdmin')): ?>
                            🗂️ All Documents - Admin View
                        <?php else: ?>
                            📋 Document Library
                        <?php endif; ?>
                    </h2>
                    <p class="text-blue-100">
                        <?php if(Auth::user()->hasRole('Contractor')): ?>
                            Manage and track your submitted documents
                        <?php elseif(Auth::user()->hasRole('SuperAdmin')): ?>
                            Complete system overview of all documents
                        <?php else: ?>
                            Browse and review construction documents
                        <?php endif; ?>
                    </p>
                </div>
                <?php if(Auth::user()->hasRole('Contractor')): ?>
                    <a href="<?php echo e(route('documents.create')); ?>" class="btn btn-white btn-lg hover-glow animate-scale-in">
                        <svg class="w-5 h-5 mr-2 animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        <span class="font-bold">Upload Document</span>
                    </a>
                <?php endif; ?>
            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <?php if(session('success')): ?>
                <div class="alert alert-success animate-fade-in">
                    <svg class="w-5 h-5 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <div class="card animate-scale-in">
                <div class="p-6 bg-white border-b border-gray-200">
                    <?php if($documents->count() > 0): ?>
                        <div class="overflow-x-auto animate-fade-in animate-stagger-2">
                            <table class="min-w-full table-auto">
                                <thead>
                                    <tr class="bg-gray-50 animate-slide-down">
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider animate-fade-in animate-stagger-1">Title</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider animate-fade-in animate-stagger-2">Type</th>
                                        <?php if(!Auth::user()->hasRole('Contractor')): ?>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider animate-fade-in animate-stagger-3">Contractor</th>
                                        <?php endif; ?>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider animate-fade-in animate-stagger-4">Status</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider animate-fade-in animate-stagger-5">Version</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider animate-fade-in animate-stagger-6">Uploaded</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider animate-fade-in animate-stagger-6">Actions</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    <?php $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="hover:bg-gray-50 transition-colors duration-200 animate-slide-up animate-stagger-<?php echo e($loop->index % 6 + 1); ?> hover-lift">
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm font-medium text-gray-900 hover-scale"><?php echo e($document->title); ?></div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">
                                                    <?php echo e($document->type); ?>

                                                </span>
                                            </td>
                                            <?php if(!Auth::user()->hasRole('Contractor')): ?>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                                    <?php echo e($document->contractor->name); ?>

                                                </td>
                                            <?php endif; ?>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                                                    <?php if(str_contains($document->current_status, 'Rejected')): ?>
                                                        bg-red-100 text-red-800
                                                    <?php elseif($document->current_status === 'Final Approved'): ?>
                                                        bg-green-100 text-green-800
                                                    <?php else: ?>
                                                        bg-yellow-100 text-yellow-800
                                                    <?php endif; ?>
                                                ">
                                                    <?php echo e($document->current_status); ?>

                                                </span>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                                v<?php echo e($document->versions->max('version_number') ?? 1); ?>

                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                                <?php echo e($document->created_at->format('M d, Y')); ?>

                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                                                <a href="<?php echo e(route('documents.show', $document)); ?>" class="text-indigo-600 hover:text-indigo-900 hover-scale transition-all duration-200">View</a>
                                                <a href="<?php echo e(route('documents.download', $document)); ?>" class="text-green-600 hover:text-green-900 hover-scale transition-all duration-200">Download</a>
                                                <?php if(Auth::user()->hasRole('Contractor') && $document->contractor_id === Auth::id()): ?>
                                                    <a href="<?php echo e(route('documents.history', $document)); ?>" class="text-blue-600 hover:text-blue-900 hover-scale transition-all duration-200">History</a>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-8">
                            <p class="text-gray-500 text-lg">
                                <?php if(Auth::user()->hasRole('Contractor')): ?>
                                    You haven't uploaded any documents yet.
                                <?php else: ?>
                                    No documents found in the system.
                                <?php endif; ?>
                            </p>
                            <?php if(Auth::user()->hasRole('Contractor')): ?>
                                <a href="<?php echo e(route('documents.create')); ?>" class="mt-4 bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded inline-block">
                                    Upload Your First Document
                                </a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da)): ?>
<?php $component = $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da; ?>
<?php unset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da); ?>
<?php endif; ?>
<?php /**PATH /Library/WebServer/Documents/atm-project/resources/views/documents/index.blade.php ENDPATH**/ ?>