<?php if (isset($component)) { $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\AppLayout::class, []); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                Document History: <?php echo e($document->title); ?>

            </h2>
            <div class="flex space-x-2">
                <a href="<?php echo e(route('documents.show', $document)); ?>" class="btn btn-primary">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                    </svg>
                    View Document
                </a>
                <a href="<?php echo e(route('documents.index')); ?>" class="btn btn-secondary">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                    Back to Documents
                </a>
            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Document Versions -->
                <div class="lg:col-span-2">
                    <div class="card animate-fade-in">
                        <div class="card-header">
                            <h3 class="text-lg font-bold text-gray-800">Document Versions</h3>
                        </div>
                        <div class="card-body">
                            <?php if($document->versions->count() > 0): ?>
                                <div class="space-y-4">
                                    <?php $__currentLoopData = $document->versions->sortByDesc('version_number'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $version): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg border-l-4
                                            <?php echo e($version->version_number === $document->versions->max('version_number') ? 'border-blue-400 bg-blue-50' : 'border-gray-300'); ?>">
                                            <div class="flex items-center space-x-4">
                                                <div class="flex-shrink-0">
                                                    <div class="w-10 h-10 bg-blue-500 text-white rounded-full flex items-center justify-center font-bold">
                                                        v<?php echo e($version->version_number); ?>

                                                    </div>
                                                </div>
                                                <div>
                                                    <p class="font-medium text-gray-900">
                                                        Version <?php echo e($version->version_number); ?>

                                                        <?php if($version->version_number === $document->versions->max('version_number')): ?>
                                                            <span class="status-badge status-final ml-2">Current</span>
                                                        <?php endif; ?>
                                                    </p>
                                                    <p class="text-sm text-gray-600">
                                                        Uploaded by <?php echo e($version->uploader->name); ?> • <?php echo e($version->created_at->format('M d, Y \a\t g:i A')); ?>

                                                    </p>
                                                    <p class="text-xs text-gray-500"><?php echo e($version->created_at->diffForHumans()); ?></p>
                                                </div>
                                            </div>
                                            <div class="flex items-center space-x-2">
                                                <a href="<?php echo e(route('documents.download', [$document, $version->id])); ?>"
                                                   class="btn btn-primary btn-sm">
                                                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                                    </svg>
                                                    Download
                                                </a>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-8">
                                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                    </svg>
                                    <h3 class="mt-2 text-sm font-medium text-gray-900">No versions found</h3>
                                    <p class="mt-1 text-sm text-gray-500">This document doesn't have any version history.</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Document Info Sidebar -->
                <div class="lg:col-span-1">
                    <div class="card animate-slide-in">
                        <div class="card-header">
                            <h3 class="text-lg font-bold text-gray-800">Document Info</h3>
                        </div>
                        <div class="card-body space-y-4">
                            <div>
                                <label class="form-label">Title</label>
                                <p class="text-gray-900 font-medium"><?php echo e($document->title); ?></p>
                            </div>
                            <div>
                                <label class="form-label">Type</label>
                                <span class="status-badge status-final"><?php echo e($document->type); ?></span>
                            </div>
                            <div>
                                <label class="form-label">Status</label>
                                <span class="status-badge
                                    <?php if(str_contains($document->current_status, 'Rejected')): ?>
                                        status-rejected
                                    <?php elseif($document->current_status === 'Final Approved'): ?>
                                        status-approved
                                    <?php else: ?>
                                        status-pending
                                    <?php endif; ?>
                                ">
                                    <?php echo e($document->current_status); ?>

                                </span>
                            </div>
                            <div>
                                <label class="form-label">Contractor</label>
                                <p class="text-gray-900"><?php echo e($document->contractor->name); ?></p>
                            </div>
                            <div>
                                <label class="form-label">First Uploaded</label>
                                <p class="text-gray-900"><?php echo e($document->created_at->format('M d, Y')); ?></p>
                            </div>
                            <div>
                                <label class="form-label">Total Versions</label>
                                <p class="text-gray-900 font-bold text-lg"><?php echo e($document->versions->count()); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Approval Timeline -->
                    <div class="card mt-6">
                        <div class="card-header">
                            <h3 class="text-lg font-bold text-gray-800">Approval Timeline</h3>
                        </div>
                        <div class="card-body">
                            <?php if($document->approvals->count() > 0): ?>
                                <div class="space-y-3">
                                    <?php $__currentLoopData = $document->approvals->sortBy('created_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $approval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="flex items-center space-x-3">
                                            <div class="flex-shrink-0">
                                                <?php if($approval->status === 'approved'): ?>
                                                    <div class="w-3 h-3 bg-green-500 rounded-full"></div>
                                                <?php elseif($approval->status === 'rejected'): ?>
                                                    <div class="w-3 h-3 bg-red-500 rounded-full"></div>
                                                <?php else: ?>
                                                    <div class="w-3 h-3 bg-yellow-500 rounded-full"></div>
                                                <?php endif; ?>
                                            </div>
                                            <div class="flex-1 min-w-0">
                                                <p class="text-sm font-medium text-gray-900"><?php echo e($approval->role); ?></p>
                                                <p class="text-xs text-gray-500"><?php echo e($approval->created_at->format('M d, Y')); ?></p>
                                            </div>
                                            <span class="status-badge
                                                <?php if($approval->status === 'approved'): ?> status-approved
                                                <?php elseif($approval->status === 'rejected'): ?> status-rejected
                                                <?php else: ?> status-pending <?php endif; ?>
                                            ">
                                                <?php echo e(ucfirst($approval->status)); ?>

                                            </span>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-4">
                                    <p class="text-sm text-gray-500">No approvals yet</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da)): ?>
<?php $component = $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da; ?>
<?php unset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da); ?>
<?php endif; ?>
<?php /**PATH /Library/WebServer/Documents/atm-project/resources/views/documents/history.blade.php ENDPATH**/ ?>