<!-- Contractor Dashboard Statistics -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-blue-600 mb-2"><?php echo e($totalDocuments ?? 0); ?></div>
            <div class="text-sm text-gray-600">Total Documents</div>
            <div class="text-xs text-gray-500 mt-1">Submitted</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-yellow-600 mb-2"><?php echo e($pendingConsultant ?? 0); ?></div>
            <div class="text-sm text-gray-600">Pending Review</div>
            <div class="text-xs text-gray-500 mt-1">Consultant</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-red-600 mb-2"><?php echo e($rejectedDocuments ?? 0); ?></div>
            <div class="text-sm text-gray-600">Rejected</div>
            <div class="text-xs text-gray-500 mt-1">Documents</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-green-600 mb-2"><?php echo e($approvedDocuments ?? 0); ?></div>
            <div class="text-sm text-gray-600">Approved</div>
            <div class="text-xs text-gray-500 mt-1">Final</div>
        </div>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
    <!-- Recent Submissions -->
    <div class="card">
        <div class="card-header">
            <h3 class="text-lg font-bold text-gray-800">Recent Submissions</h3>
        </div>
        <div class="card-body">
            <?php if(isset($recentSubmissions) && $recentSubmissions->count() > 0): ?>
                <div class="space-y-4">
                    <?php $__currentLoopData = $recentSubmissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                            <div class="flex-1">
                                <h4 class="font-medium text-gray-900"><?php echo e($document->title); ?></h4>
                                <p class="text-sm text-gray-600"><?php echo e($document->type); ?></p>
                                <p class="text-xs text-gray-500"><?php echo e($document->created_at->diffForHumans()); ?></p>
                            </div>
                            <div class="text-right">
                                <span class="status-badge
                                    <?php if(str_contains($document->current_status, 'Rejected')): ?>
                                        status-rejected
                                    <?php elseif($document->current_status === 'Final Approved'): ?>
                                        status-approved
                                    <?php else: ?>
                                        status-pending
                                    <?php endif; ?>
                                ">
                                    <?php echo e($document->current_status); ?>

                                </span>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="mt-4 text-center">
                    <a href="<?php echo e(route('documents.index')); ?>" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                        View All Documents →
                    </a>
                </div>
            <?php else: ?>
                <div class="text-center py-8">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    <h3 class="mt-2 text-sm font-medium text-gray-900">No documents yet</h3>
                    <p class="mt-1 text-sm text-gray-500">Start by uploading your first document.</p>
                    <div class="mt-4">
                        <a href="<?php echo e(route('documents.create')); ?>" class="btn btn-primary">
                            Upload Document
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Document Categories Chart -->
    <div class="card">
        <div class="card-header">
            <h3 class="text-lg font-bold text-gray-800">Document Categories</h3>
        </div>
        <div class="card-body">
            <canvas id="categoriesChart" width="400" height="300"></canvas>
        </div>
    </div>
</div>

<!-- Document Status Distribution -->
<div class="card mb-8">
    <div class="card-header">
        <h3 class="text-lg font-bold text-gray-800">Status Distribution</h3>
    </div>
    <div class="card-body">
        <canvas id="statusChart" width="800" height="300"></canvas>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Document Categories Pie Chart
    <?php if(isset($documentCategories) && $documentCategories->count() > 0): ?>
    const categoriesCtx = document.getElementById('categoriesChart').getContext('2d');
    new Chart(categoriesCtx, {
        type: 'doughnut',
        data: {
            labels: [
                <?php $__currentLoopData = $documentCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    '<?php echo e($category->type); ?>',
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ],
            datasets: [{
                data: [
                    <?php $__currentLoopData = $documentCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($category->count); ?>,
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ],
                backgroundColor: [
                    '#3B82F6', '#10B981', '#F59E0B', '#EF4444', '#8B5CF6'
                ],
                borderWidth: 2,
                borderColor: '#ffffff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true
                    }
                }
            }
        }
    });
    <?php endif; ?>

    // Status Distribution Bar Chart
    <?php if(isset($statusDistribution) && $statusDistribution->count() > 0): ?>
    const statusCtx = document.getElementById('statusChart').getContext('2d');
    new Chart(statusCtx, {
        type: 'bar',
        data: {
            labels: [
                <?php $__currentLoopData = $statusDistribution; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    '<?php echo e($status->current_status); ?>',
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ],
            datasets: [{
                label: 'Documents',
                data: [
                    <?php $__currentLoopData = $statusDistribution; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($status->count); ?>,
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ],
                backgroundColor: [
                    <?php $__currentLoopData = $statusDistribution; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(str_contains($status->current_status, 'Rejected')): ?>
                            '#EF4444',
                        <?php elseif($status->current_status === 'Final Approved'): ?>
                            '#10B981',
                        <?php else: ?>
                            '#F59E0B',
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ],
                borderColor: [
                    <?php $__currentLoopData = $statusDistribution; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(str_contains($status->current_status, 'Rejected')): ?>
                            '#DC2626',
                        <?php elseif($status->current_status === 'Final Approved'): ?>
                            '#059669',
                        <?php else: ?>
                            '#D97706',
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            },
            plugins: {
                legend: {
                    display: false
                }
            }
        }
    });
    <?php endif; ?>
});
</script>
<?php /**PATH /Library/WebServer/Documents/atm-project/resources/views/dashboard/contractor.blade.php ENDPATH**/ ?>