<?php if (isset($component)) { $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\AppLayout::class, []); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="page-header">
            <div class="flex justify-between items-center">
                <div class="flex items-center">
                    <svg class="w-8 h-8 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                    </svg>
                    <div>
                        <h2 class="font-bold text-2xl mb-1">
                            <?php if(Auth::user()->hasRole('SuperAdmin')): ?>
                                👑 Admin Panel - User Management
                            <?php else: ?>
                                👥 User Management
                            <?php endif; ?>
                        </h2>
                        <p class="text-blue-100">
                            <?php if(Auth::user()->hasRole('SuperAdmin')): ?>
                                Full system administration and user control
                            <?php else: ?>
                                Assign roles and manage user permissions
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
                <?php if(Auth::user()->hasRole('SuperAdmin')): ?>
                    <a href="<?php echo e(route('users.create')); ?>" class="btn bg-white text-blue-600 hover:bg-blue-50 font-semibold">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Create User
                    </a>
                <?php endif; ?>
            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <?php if(session('success')): ?>
                <div class="alert alert-success animate-fade-in">
                    <svg class="w-5 h-5 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <div class="card animate-fade-in">
                <div class="card-header">
                    <h3 class="text-lg font-bold text-gray-800">All Users</h3>
                </div>
                <div class="card-body">
                    <?php if($users->count() > 0): ?>
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Role</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Joined</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="hover:bg-gray-50">
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="flex items-center">
                                                    <div class="flex-shrink-0 h-10 w-10">
                                                        <div class="h-10 w-10 rounded-full bg-blue-500 flex items-center justify-center">
                                                            <span class="text-white font-medium text-sm">
                                                                <?php echo e(substr($user->name, 0, 2)); ?>

                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="ml-4">
                                                        <div class="text-sm font-medium text-gray-900"><?php echo e($user->name); ?></div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm text-gray-900"><?php echo e($user->email); ?></div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <?php if($user->roles->count() > 0): ?>
                                                    <span class="status-badge status-final">
                                                        <?php echo e($user->roles->first()->name); ?>

                                                    </span>
                                                <?php else: ?>
                                                    <span class="status-badge bg-gray-100 text-gray-800">No Role</span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                                <?php echo e($user->created_at->format('M d, Y')); ?>

                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                                                <a href="<?php echo e(route('users.assign-role', $user)); ?>" class="text-blue-600 hover:text-blue-900">
                                                    Assign Role
                                                </a>
                                                <?php if(Auth::user()->hasRole('SuperAdmin') && $user->id !== Auth::id()): ?>
                                                    <form action="<?php echo e(route('users.destroy', $user)); ?>" method="POST" class="inline">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="text-red-600 hover:text-red-900"
                                                                onclick="return confirm('Are you sure you want to delete this user? This action cannot be undone.')">
                                                            Delete
                                                        </button>
                                                    </form>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <?php if($users->hasPages()): ?>
                            <div class="mt-6">
                                <?php echo e($users->links()); ?>

                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="text-center py-8">
                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                            </svg>
                            <h3 class="mt-2 text-sm font-medium text-gray-900">No users found</h3>
                            <p class="mt-1 text-sm text-gray-500">No users are registered in the system.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Role Statistics -->
            <div class="grid grid-cols-1 md:grid-cols-5 gap-6 mt-6">
                <?php
                    $roleStats = [
                        'Contractor' => $users->filter(fn($u) => $u->hasRole('Contractor'))->count(),
                        'Consultant' => $users->filter(fn($u) => $u->hasRole('Consultant'))->count(),
                        'ClientA' => $users->filter(fn($u) => $u->hasRole('ClientA'))->count(),
                        'ClientB' => $users->filter(fn($u) => $u->hasRole('ClientB'))->count(),
                        'ClientC' => $users->filter(fn($u) => $u->hasRole('ClientC'))->count(),
                    ];
                ?>

                <?php $__currentLoopData = $roleStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role => $count): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card">
                        <div class="card-body text-center">
                            <div class="text-2xl font-bold text-blue-600"><?php echo e($count); ?></div>
                            <div class="text-sm text-gray-600"><?php echo e($role); ?></div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da)): ?>
<?php $component = $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da; ?>
<?php unset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da); ?>
<?php endif; ?>
<?php /**PATH /Library/WebServer/Documents/atm-project/resources/views/users/index.blade.php ENDPATH**/ ?>