<?php if (isset($component)) { $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\AppLayout::class, []); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                Review Document: <?php echo e($document->title); ?>

            </h2>
            <a href="<?php echo e(route('approvals.index')); ?>" class="btn btn-secondary">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                </svg>
                Back to Approvals
            </a>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <?php if($errors->any()): ?>
                <div class="alert alert-error animate-fade-in mb-6">
                    <svg class="w-5 h-5 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <strong>Please fix the following errors:</strong>
                    <ul class="list-disc list-inside mt-2">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Document Details -->
                <div class="lg:col-span-2">
                    <div class="card animate-fade-in">
                        <div class="card-header">
                            <h3 class="text-lg font-bold text-gray-800">Document Information</h3>
                        </div>
                        <div class="card-body">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                                <div>
                                    <label class="form-label">Title</label>
                                    <p class="text-gray-900 font-medium"><?php echo e($document->title); ?></p>
                                </div>
                                <div>
                                    <label class="form-label">Type</label>
                                    <span class="status-badge status-final"><?php echo e($document->type); ?></span>
                                </div>
                                <div>
                                    <label class="form-label">Contractor</label>
                                    <p class="text-gray-900"><?php echo e($document->contractor->name); ?></p>
                                </div>
                                <div>
                                    <label class="form-label">Current Status</label>
                                    <span class="status-badge status-pending"><?php echo e($document->current_status); ?></span>
                                </div>
                                <div>
                                    <label class="form-label">Version</label>
                                    <p class="text-gray-900">v<?php echo e($document->versions->max('version_number') ?? 1); ?></p>
                                </div>
                                <div>
                                    <label class="form-label">Uploaded</label>
                                    <p class="text-gray-900"><?php echo e($document->created_at->format('M d, Y \a\t g:i A')); ?></p>
                                </div>
                            </div>

                            <div class="flex space-x-3 mb-6">
                                <a href="<?php echo e(route('documents.download', $document)); ?>" class="btn btn-primary">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                    </svg>
                                    Download Document
                                </a>
                                <a href="<?php echo e(route('documents.show', $document)); ?>" class="btn btn-secondary">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                    </svg>
                                    View Details
                                </a>
                            </div>

                            <!-- Review Form -->
                            <div class="border-t border-gray-200 pt-6">
                                <h4 class="text-lg font-semibold mb-4">Submit Your Review</h4>
                                <form action="<?php echo e(route('approvals.process', $document)); ?>" method="POST" class="space-y-6">
                                    <?php echo csrf_field(); ?>

                                    <div>
                                        <label class="form-label">Comments (Optional)</label>
                                        <textarea name="comments" rows="4" placeholder="Add any comments about this document..."
                                            class="form-input"><?php echo e(old('comments')); ?></textarea>
                                        <p class="text-sm text-gray-500 mt-1">Provide feedback, suggestions, or reasons for your decision.</p>
                                    </div>

                                    <div class="flex space-x-4 animate-slide-up animate-stagger-3">
                                        <button type="submit" name="action" value="approve"
                                                class="btn btn-success flex-1 justify-center btn-lg hover-glow animate-scale-in animate-stagger-1"
                                                onclick="return confirm('Are you sure you want to approve this document?')">
                                            <svg class="w-5 h-5 mr-2 animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                            </svg>
                                            <span class="font-bold">Approve Document</span>
                                        </button>
                                        <button type="submit" name="action" value="reject"
                                                class="btn btn-danger flex-1 justify-center btn-lg hover-glow animate-scale-in animate-stagger-2"
                                                onclick="return confirm('Are you sure you want to reject this document?')">
                                            <svg class="w-5 h-5 mr-2 animate-bounce-in" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                            </svg>
                                            <span class="font-bold">Reject Document</span>
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Previous Reviews Sidebar -->
                <div class="lg:col-span-1">
                    <div class="card animate-slide-in">
                        <div class="card-header">
                            <h3 class="text-lg font-bold text-gray-800">Previous Reviews</h3>
                        </div>
                        <div class="card-body">
                            <?php if($document->approvals->count() > 0): ?>
                                <div class="space-y-4">
                                    <?php $__currentLoopData = $document->approvals->sortBy('created_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $approval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="p-4 bg-gray-50 rounded-lg border-l-4
                                            <?php echo e($approval->status === 'approved' ? 'border-green-400' : ($approval->status === 'rejected' ? 'border-red-400' : 'border-yellow-400')); ?>">
                                            <div class="flex items-center justify-between mb-2">
                                                <p class="font-medium text-gray-900"><?php echo e($approval->reviewer->name); ?></p>
                                                <span class="status-badge
                                                    <?php if($approval->status === 'approved'): ?> status-approved
                                                    <?php elseif($approval->status === 'rejected'): ?> status-rejected
                                                    <?php else: ?> status-pending <?php endif; ?>
                                                ">
                                                    <?php echo e(ucfirst($approval->status)); ?>

                                                </span>
                                            </div>
                                            <p class="text-sm text-gray-600 mb-1"><?php echo e($approval->role); ?></p>
                                            <p class="text-xs text-gray-500 mb-3"><?php echo e($approval->created_at->format('M d, Y \a\t g:i A')); ?></p>
                                            <?php if($approval->comments): ?>
                                                <div class="bg-white p-3 rounded border">
                                                    <p class="text-sm text-gray-700"><?php echo e($approval->comments); ?></p>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-6">
                                    <svg class="mx-auto h-8 w-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                                    </svg>
                                    <p class="text-sm text-gray-500 mt-2">No previous reviews</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Workflow Status -->
                    <div class="card mt-6">
                        <div class="card-header">
                            <h3 class="text-lg font-bold text-gray-800">Approval Workflow</h3>
                        </div>
                        <div class="card-body">
                            <div class="space-y-3">
                                <div class="flex items-center space-x-3">
                                    <div class="w-3 h-3 bg-green-500 rounded-full"></div>
                                    <span class="text-sm text-gray-700">Contractor Upload</span>
                                </div>
                                <div class="flex items-center space-x-3">
                                    <div class="w-3 h-3 <?php echo e(str_contains($document->current_status, 'Consultant') ? 'bg-blue-500' : 'bg-green-500'); ?> rounded-full"></div>
                                    <span class="text-sm text-gray-700">Consultant Review</span>
                                </div>
                                <div class="flex items-center space-x-3">
                                    <div class="w-3 h-3 <?php echo e(str_contains($document->current_status, 'Client A') ? 'bg-blue-500' : (str_contains($document->current_status, 'Client B') || $document->current_status === 'Final Approved' ? 'bg-green-500' : 'bg-gray-300')); ?> rounded-full"></div>
                                    <span class="text-sm text-gray-700">Client A Review</span>
                                </div>
                                <div class="flex items-center space-x-3">
                                    <div class="w-3 h-3 <?php echo e(str_contains($document->current_status, 'Client B') ? 'bg-blue-500' : ($document->current_status === 'Final Approved' ? 'bg-green-500' : 'bg-gray-300')); ?> rounded-full"></div>
                                    <span class="text-sm text-gray-700">Client B & C Review</span>
                                </div>
                                <div class="flex items-center space-x-3">
                                    <div class="w-3 h-3 <?php echo e($document->current_status === 'Final Approved' ? 'bg-green-500' : 'bg-gray-300'); ?> rounded-full"></div>
                                    <span class="text-sm text-gray-700">Final Approval</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da)): ?>
<?php $component = $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da; ?>
<?php unset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da); ?>
<?php endif; ?>
<?php /**PATH /Library/WebServer/Documents/atm-project/resources/views/approvals/show.blade.php ENDPATH**/ ?>