<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>ConstructFlow - Construction Document Management System</title>

        <!-- Fonts -->
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

        <!-- Scripts -->
        <link href="<?php echo e(mix('css/app.css')); ?>" rel="stylesheet">
        <script src="<?php echo e(mix('js/app.js')); ?>" defer></script>
    </head>
    <body class="font-sans antialiased">
        <!-- Navigation -->
        <nav class="bg-white shadow-lg fixed w-full z-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-16">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 flex items-center">
                            <svg class="h-8 w-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                            </svg>
                            <span class="ml-2 text-xl font-bold text-gray-900">ConstructFlow</span>
                        </div>
                    </div>
                    <div class="flex items-center space-x-4">
                    <?php if(auth()->guard()->check()): ?>
                            <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-primary">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z"></path>
                                </svg>
                                Dashboard
                            </a>
                    <?php else: ?>
                            <a href="<?php echo e(route('login')); ?>" class="btn btn-primary">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path>
                                </svg>
                                Login
                            </a>
                    <?php endif; ?>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Hero Section -->
        <div class="pt-16 relative min-h-screen overflow-hidden">
            <!-- Enhanced Animated Background -->
            <div class="absolute inset-0 bg-gradient-to-br from-blue-900 via-purple-900 to-indigo-900">
                <div class="absolute inset-0 bg-gradient-to-t from-black/30 via-transparent to-transparent"></div>
                <!-- Dynamic Floating Elements -->
                <div class="absolute top-20 left-10 w-96 h-96 bg-blue-500 rounded-full mix-blend-multiply filter blur-3xl opacity-30 animate-float"></div>
                <div class="absolute top-40 right-10 w-80 h-80 bg-purple-500 rounded-full mix-blend-multiply filter blur-3xl opacity-25 animate-float" style="animation-delay: 2s;"></div>
                <div class="absolute bottom-20 left-1/2 w-72 h-72 bg-indigo-500 rounded-full mix-blend-multiply filter blur-2xl opacity-20 animate-float" style="animation-delay: 4s;"></div>
                <div class="absolute top-1/2 left-20 w-64 h-64 bg-yellow-500 rounded-full mix-blend-multiply filter blur-2xl opacity-15 animate-float" style="animation-delay: 1s;"></div>
                <div class="absolute bottom-40 right-20 w-56 h-56 bg-pink-500 rounded-full mix-blend-multiply filter blur-xl opacity-25 animate-float" style="animation-delay: 3s;"></div>
            </div>

            <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pt-20 pb-16">
                <div class="text-center">
                    <!-- Badge -->
                    <div class="inline-flex items-center px-4 py-2 bg-white/10 backdrop-blur-sm rounded-full text-white text-sm font-medium mb-8 animate-bounce-in">
                        <svg class="w-4 h-4 mr-2 animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                        <span class="animate-glow">Revolutionizing Construction Management</span>
                </div>

                    <h1 class="text-5xl md:text-8xl font-black text-white mb-8 animate-slide-down leading-tight">
                        <span class="block animate-fade-in">Build Smarter</span>
                        <span class="block bg-gradient-to-r from-yellow-400 via-orange-400 to-red-400 bg-clip-text text-transparent animate-glow animate-stagger-1">
                            Manage Better
                        </span>
                        <span class="block text-3xl md:text-5xl font-bold text-blue-200 mt-6 animate-bounce-in animate-stagger-2">
                            with ConstructFlow ✨
                        </span>
                    </h1>

                    <p class="text-xl md:text-2xl text-blue-100 mb-12 max-w-4xl mx-auto leading-relaxed animate-slide-up animate-stagger-3">
                        Transform your construction projects with our intelligent document management system.
                        <span class="text-yellow-300 font-semibold">Streamline workflows</span>,
                        <span class="text-green-300 font-semibold">accelerate approvals</span>, and
                        <span class="text-purple-300 font-semibold">boost collaboration</span> like never before.
                    </p>

                    <div class="flex flex-col sm:flex-row gap-6 justify-center animate-scale-in animate-stagger-4">
                        <?php if(auth()->guard()->check()): ?>
                            <a href="<?php echo e(route('dashboard')); ?>" class="group relative overflow-hidden bg-gradient-to-r from-yellow-400 to-orange-500 text-gray-900 font-black py-6 px-12 rounded-2xl text-xl shadow-2xl hover:shadow-3xl transform hover:-translate-y-2 transition-all duration-300 animate-bounce-in">
                                <span class="absolute inset-0 bg-gradient-to-r from-yellow-300 to-orange-400 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></span>
                                <div class="relative z-10 flex items-center">
                                    <svg class="w-7 h-7 mr-3 animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z"></path>
                                    </svg>
                                    <span>Go to Dashboard</span>
                                    <div class="ml-3 w-2 h-2 bg-green-500 rounded-full animate-pulse"></div>
                                </div>
                            </a>
                        <?php else: ?>
                            <a href="<?php echo e(route('login')); ?>" class="group relative overflow-hidden bg-gradient-to-r from-yellow-400 to-orange-500 text-gray-900 font-black py-6 px-12 rounded-2xl text-xl shadow-2xl hover:shadow-3xl transform hover:-translate-y-2 transition-all duration-300 animate-bounce-in">
                                <span class="absolute inset-0 bg-gradient-to-r from-yellow-300 to-orange-400 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></span>
                                <div class="relative z-10 flex items-center">
                                    <svg class="w-7 h-7 mr-3 animate-float" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path>
                                    </svg>
                                    <span>Start Building Today</span>
                                    <div class="ml-3 w-2 h-2 bg-green-500 rounded-full animate-pulse"></div>
                                </div>
                            </a>
                        <?php endif; ?>

                        <a href="#features" class="group bg-white/10 backdrop-blur-sm border border-white/20 text-white font-bold py-6 px-12 rounded-2xl text-xl hover:bg-white/20 transition-all duration-300 animate-bounce-in animate-stagger-2">
                            <div class="flex items-center">
                                <svg class="w-7 h-7 mr-3 animate-rotate-slow" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <span>Explore Features</span>
                            </div>
                        </a>
                    </div>

                    <!-- Trust Indicators -->
                    <div class="mt-16 flex flex-col sm:flex-row items-center justify-center space-y-6 sm:space-y-0 sm:space-x-12 text-white/80 animate-fade-in animate-stagger-5">
                        <div class="flex items-center hover-scale">
                            <svg class="w-6 h-6 mr-3 text-green-400 animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.5-1.5a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                            </svg>
                            <span class="font-semibold">Enterprise Security</span>
                        </div>
                        <div class="flex items-center hover-scale">
                            <svg class="w-6 h-6 mr-3 text-blue-400 animate-float" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                            </svg>
                            <span class="font-semibold">Lightning Fast</span>
                        </div>
                        <div class="flex items-center hover-scale">
                            <svg class="w-6 h-6 mr-3 text-purple-400 animate-bounce-in" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                            </svg>
                            <span class="font-semibold">Loved by Teams</span>
                        </div>
                        <div class="flex items-center hover-scale">
                            <svg class="w-6 h-6 mr-3 text-yellow-400 animate-glow" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"></path>
                            </svg>
                            <span class="font-semibold">Award Winning</span>
                        </div>
                    </div>
                            </div>

                <!-- Hero Image/Illustration -->
                <div class="mt-16 relative animate-scale-in animate-stagger-4">
                    <div class="absolute inset-0 bg-gradient-to-r from-blue-600 to-purple-600 transform rotate-1 rounded-3xl opacity-10 animate-float"></div>
                    <div class="relative bg-white rounded-2xl shadow-2xl p-8 border border-gray-200 hover-lift">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                            <div class="text-center animate-fade-in animate-stagger-1 hover-scale">
                                <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4 hover-glow">
                                    <svg class="w-8 h-8 text-green-600 animate-float" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                                    </svg>
                                </div>
                                <h3 class="text-lg font-semibold text-gray-900 mb-2">Upload Documents</h3>
                                <p class="text-gray-600 text-sm">Contractors upload construction documents with automatic version control</p>
                            </div>
                            <div class="text-center animate-fade-in animate-stagger-2 hover-scale">
                                <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4 hover-glow">
                                    <svg class="w-8 h-8 text-blue-600 animate-pulse-slow" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"></path>
                                    </svg>
                        </div>
                                <h3 class="text-lg font-semibold text-gray-900 mb-2">Review & Approve</h3>
                                <p class="text-gray-600 text-sm">Multi-stage approval workflow with consultant and client reviews</p>
                            </div>
                            <div class="text-center animate-fade-in animate-stagger-3 hover-scale">
                                <div class="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-4 hover-glow">
                                    <svg class="w-8 h-8 text-purple-600 animate-rotate-slow" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                                    </svg>
                                </div>
                                <h3 class="text-lg font-semibold text-gray-900 mb-2">Track Progress</h3>
                                <p class="text-gray-600 text-sm">Real-time analytics and progress tracking with detailed reporting</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics Section -->
        <section class="py-20 bg-white relative overflow-hidden">
            <div class="absolute inset-0 bg-gradient-to-r from-blue-50 to-purple-50 opacity-50"></div>
            <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-16">
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4 animate-fade-in">
                        Trusted by Construction Teams Worldwide
                    </h2>
                    <p class="text-xl text-gray-600 animate-slide-up animate-stagger-1">
                        Join thousands of professionals already streamlining their workflows
                    </p>
                </div>

                <div class="grid grid-cols-2 md:grid-cols-4 gap-8">
                    <div class="text-center animate-scale-in animate-stagger-1 hover-scale">
                        <div class="text-4xl md:text-6xl font-black text-blue-600 mb-2 animate-bounce-in">1000+</div>
                        <div class="text-sm md:text-base font-semibold text-gray-700">Projects Managed</div>
                        <div class="text-xs text-gray-500 mt-1">Across 50+ Countries</div>
                    </div>
                    <div class="text-center animate-scale-in animate-stagger-2 hover-scale">
                        <div class="text-4xl md:text-6xl font-black text-green-600 mb-2 animate-bounce-in">50K+</div>
                        <div class="text-sm md:text-base font-semibold text-gray-700">Documents Processed</div>
                        <div class="text-xs text-gray-500 mt-1">With 99.9% Uptime</div>
                    </div>
                    <div class="text-center animate-scale-in animate-stagger-3 hover-scale">
                        <div class="text-4xl md:text-6xl font-black text-purple-600 mb-2 animate-bounce-in">95%</div>
                        <div class="text-sm md:text-base font-semibold text-gray-700">Faster Approvals</div>
                        <div class="text-xs text-gray-500 mt-1">Average Time Saved</div>
                    </div>
                    <div class="text-center animate-scale-in animate-stagger-4 hover-scale">
                        <div class="text-4xl md:text-6xl font-black text-orange-600 mb-2 animate-bounce-in">24/7</div>
                        <div class="text-sm md:text-base font-semibold text-gray-700">Support & Monitoring</div>
                        <div class="text-xs text-gray-500 mt-1">Always Available</div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Features Section -->
        <section id="features" class="py-20 bg-gradient-to-br from-gray-50 to-blue-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-16">
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
                        Powerful Features for Construction Teams
                    </h2>
                    <p class="text-xl text-gray-600 max-w-2xl mx-auto">
                        Everything you need to manage construction documents efficiently and securely
                    </p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <!-- Feature 1 -->
                    <div class="bg-white rounded-xl shadow-lg p-8 hover:shadow-xl transition-all duration-300 animate-slide-up animate-stagger-1 hover-lift">
                        <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mb-6 hover-scale">
                            <svg class="w-6 h-6 text-blue-600 animate-pulse-slow" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-3">Role-Based Access</h3>
                        <p class="text-gray-600">Secure access control with distinct roles for contractors, consultants, and clients with appropriate permissions.</p>
                    </div>

                    <!-- Feature 2 -->
                    <div class="bg-white rounded-xl shadow-lg p-8 hover:shadow-xl transition-all duration-300 animate-slide-up animate-stagger-2 hover-lift">
                        <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center mb-6 hover-scale">
                            <svg class="w-6 h-6 text-green-600 animate-float" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-3">Document Management</h3>
                        <p class="text-gray-600">Upload, organize, and manage construction documents with automatic version control and file history.</p>
                    </div>

                    <!-- Feature 3 -->
                    <div class="bg-white rounded-xl shadow-lg p-8 hover:shadow-xl transition-all duration-300 animate-slide-up animate-stagger-3 hover-lift">
                        <div class="w-12 h-12 bg-orange-100 rounded-lg flex items-center justify-center mb-6 hover-scale">
                            <svg class="w-6 h-6 text-orange-600 animate-bounce-in" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-3">Approval Workflow</h3>
                        <p class="text-gray-600">Automated multi-stage approval process with consultant and client reviews, ensuring quality control.</p>
                    </div>

                    <!-- Feature 4 -->
                    <div class="bg-white rounded-xl shadow-lg p-8 hover:shadow-xl transition-all duration-300 animate-slide-up animate-stagger-4 hover-lift">
                        <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center mb-6 hover-scale">
                            <svg class="w-6 h-6 text-purple-600 animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-5 5v-5zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-3">Real-Time Notifications</h3>
                        <p class="text-gray-600">Instant notifications for document updates, approvals, and rejections to keep everyone informed.</p>
                    </div>

                    <!-- Feature 5 -->
                    <div class="bg-white rounded-xl shadow-lg p-8 hover:shadow-xl transition-all duration-300 animate-slide-up animate-stagger-5 hover-lift">
                        <div class="w-12 h-12 bg-indigo-100 rounded-lg flex items-center justify-center mb-6 hover-scale">
                            <svg class="w-6 h-6 text-indigo-600 animate-rotate-slow" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-3">Analytics & Reporting</h3>
                        <p class="text-gray-600">Comprehensive analytics with charts, approval trends, and performance metrics for data-driven decisions.</p>
                    </div>

                    <!-- Feature 6 -->
                    <div class="bg-white rounded-xl shadow-lg p-8 hover:shadow-xl transition-all duration-300 animate-slide-up animate-stagger-6 hover-lift">
                        <div class="w-12 h-12 bg-red-100 rounded-lg flex items-center justify-center mb-6 hover-scale">
                            <svg class="w-6 h-6 text-red-600 animate-glow" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-3">Secure & Compliant</h3>
                        <p class="text-gray-600">Enterprise-grade security with role-based permissions and audit trails for compliance requirements.</p>
                    </div>
                </div>
            </div>
        </section>

        <!-- Document Types Section -->
        <section class="py-20 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-16">
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
                        Supported Document Types
                    </h2>
                    <p class="text-xl text-gray-600">
                        Manage all your construction documents in one place
                    </p>
                </div>

                <div class="grid grid-cols-2 md:grid-cols-5 gap-6">
                    <div class="text-center p-6 bg-gray-50 rounded-xl hover:bg-blue-50 transition-all duration-300 animate-bounce-in animate-stagger-1 hover-lift hover-scale">
                        <div class="text-4xl mb-3 animate-float">📐</div>
                        <h3 class="font-semibold text-gray-900">Design</h3>
                        <p class="text-sm text-gray-600 mt-1">Architectural plans</p>
                    </div>
                    <div class="text-center p-6 bg-gray-50 rounded-xl hover:bg-green-50 transition-all duration-300 animate-bounce-in animate-stagger-2 hover-lift hover-scale">
                        <div class="text-4xl mb-3 animate-pulse-slow">📋</div>
                        <h3 class="font-semibold text-gray-900">MAS</h3>
                        <p class="text-sm text-gray-600 mt-1">Method statements</p>
                    </div>
                    <div class="text-center p-6 bg-gray-50 rounded-xl hover:bg-yellow-50 transition-all duration-300 animate-bounce-in animate-stagger-3 hover-lift hover-scale">
                        <div class="text-4xl mb-3 animate-bounce-in">✅</div>
                        <h3 class="font-semibold text-gray-900">TQ</h3>
                        <p class="text-sm text-gray-600 mt-1">Technical queries</p>
                    </div>
                    <div class="text-center p-6 bg-gray-50 rounded-xl hover:bg-orange-50 transition-all duration-300 animate-bounce-in animate-stagger-4 hover-lift hover-scale">
                        <div class="text-4xl mb-3 animate-rotate-slow">🔧</div>
                        <h3 class="font-semibold text-gray-900">ST</h3>
                        <p class="text-sm text-gray-600 mt-1">Structural tests</p>
                    </div>
                    <div class="text-center p-6 bg-gray-50 rounded-xl hover:bg-purple-50 transition-all duration-300 animate-bounce-in animate-stagger-5 hover-lift hover-scale">
                        <div class="text-4xl mb-3 animate-glow">🔍</div>
                        <h3 class="font-semibold text-gray-900">Material Inspection</h3>
                        <p class="text-sm text-gray-600 mt-1">Quality reports</p>
                    </div>
                </div>
            </div>
        </section>

        <!-- Workflow Section -->
        <section class="py-20 bg-gradient-to-br from-blue-50 to-indigo-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-16">
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
                        Streamlined Approval Workflow
                    </h2>
                    <p class="text-xl text-gray-600">
                        Automated process ensures quality and compliance at every stage
                    </p>
                </div>

                <div class="relative">
                    <!-- Workflow Steps -->
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                        <div class="text-center animate-scale-in animate-stagger-1 hover-scale">
                            <div class="w-16 h-16 bg-blue-600 text-white rounded-full flex items-center justify-center mx-auto mb-4 font-bold text-xl shadow-lg hover-glow animate-pulse-slow">1</div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">Contractor Upload</h3>
                            <p class="text-gray-600 text-sm">Contractors upload documents for review with automatic notifications</p>
                        </div>
                        <div class="text-center animate-scale-in animate-stagger-2 hover-scale">
                            <div class="w-16 h-16 bg-green-600 text-white rounded-full flex items-center justify-center mx-auto mb-4 font-bold text-xl shadow-lg hover-glow animate-bounce-in">2</div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">Consultant Review</h3>
                            <p class="text-gray-600 text-sm">Technical review and approval by qualified consultants</p>
                        </div>
                        <div class="text-center animate-scale-in animate-stagger-3 hover-scale">
                            <div class="w-16 h-16 bg-orange-600 text-white rounded-full flex items-center justify-center mx-auto mb-4 font-bold text-xl shadow-lg hover-glow animate-float">3</div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">Client A Review</h3>
                            <p class="text-gray-600 text-sm">Primary client approval with comments and feedback</p>
                        </div>
                        <div class="text-center animate-scale-in animate-stagger-4 hover-scale">
                            <div class="w-16 h-16 bg-purple-600 text-white rounded-full flex items-center justify-center mx-auto mb-4 font-bold text-xl shadow-lg hover-glow animate-glow">4</div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">Final Approval</h3>
                            <p class="text-gray-600 text-sm">Client B & C final review with rejection rights</p>
                        </div>
                    </div>

                    <!-- Connecting Lines (hidden on mobile) -->
                    <div class="hidden md:block absolute top-8 left-0 right-0 h-0.5 bg-gray-300 -z-10"></div>
                </div>
            </div>
        </section>

        <!-- CTA Section -->
        <section class="py-24 bg-gradient-to-r from-blue-600 via-purple-600 to-indigo-600 relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute inset-0" style="background-image: url('data:image/svg+xml,<svg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"><g fill="none" fill-rule="evenodd"><g fill="%23ffffff" fill-opacity="0.1"><circle cx="30" cy="30" r="4"/></g></svg>');"></div>
            </div>

            <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 text-center relative z-10">
                <div class="animate-fade-in">
                    <h2 class="text-4xl md:text-5xl font-bold text-white mb-6 leading-tight">
                        Ready to Streamline Your
                        <span class="text-yellow-300">Construction Projects?</span>
                    </h2>
                    <p class="text-xl md:text-2xl text-blue-100 mb-12 max-w-3xl mx-auto leading-relaxed">
                        Join teams already using <span class="font-semibold text-white">ConstructFlow</span> to manage their document workflows efficiently
                    </p>
                </div>

                <?php if(auth()->guard()->guest()): ?>
                    <div class="animate-slide-in">
                        <a href="<?php echo e(route('login')); ?>" class="group relative inline-flex items-center justify-center px-12 py-4 text-xl font-bold text-blue-600 bg-white rounded-full shadow-2xl hover:shadow-3xl transform hover:-translate-y-1 transition-all duration-300 ease-out">
                            <span class="absolute inset-0 w-full h-full bg-gradient-to-r from-yellow-400 to-orange-400 rounded-full opacity-0 group-hover:opacity-20 transition-opacity duration-300"></span>
                            <svg class="w-6 h-6 mr-3 group-hover:animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path>
                            </svg>
                            <span class="relative z-10">Access System Now</span>
                            <div class="ml-3 w-2 h-2 bg-green-400 rounded-full animate-pulse"></div>
                        </a>

                        <!-- Additional CTA Info -->
                        <div class="mt-8 flex flex-col sm:flex-row items-center justify-center space-y-4 sm:space-y-0 sm:space-x-8 text-blue-100">
                            <div class="flex items-center">
                                <svg class="w-5 h-5 mr-2 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <span class="text-sm font-medium">No Registration Required</span>
                            </div>
                            <div class="flex items-center">
                                <svg class="w-5 h-5 mr-2 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                                </svg>
                                <span class="text-sm font-medium">Secure Access</span>
                            </div>
                            <div class="flex items-center">
                                <svg class="w-5 h-5 mr-2 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                                </svg>
                                <span class="text-sm font-medium">Instant Access</span>
                            </div>
                                </div>

                        <!-- Demo Account Hint -->
                        <div class="mt-8 p-4 bg-white bg-opacity-10 rounded-xl backdrop-blur-sm border border-white border-opacity-20">
                            <p class="text-blue-100 text-sm mb-2">
                                <svg class="w-4 h-4 mr-1 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <strong>Demo Available:</strong> Try different roles with pre-configured accounts
                            </p>
                            <div class="flex flex-wrap justify-center gap-2 text-xs">
                                <span class="px-2 py-1 bg-white bg-opacity-20 rounded text-white">SuperAdmin</span>
                                <span class="px-2 py-1 bg-white bg-opacity-20 rounded text-white">Contractor</span>
                                <span class="px-2 py-1 bg-white bg-opacity-20 rounded text-white">Consultant</span>
                                <span class="px-2 py-1 bg-white bg-opacity-20 rounded text-white">Client A/B/C</span>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="animate-slide-in">
                        <a href="<?php echo e(route('dashboard')); ?>" class="group relative inline-flex items-center justify-center px-12 py-4 text-xl font-bold text-blue-600 bg-white rounded-full shadow-2xl hover:shadow-3xl transform hover:-translate-y-1 transition-all duration-300 ease-out">
                            <span class="absolute inset-0 w-full h-full bg-gradient-to-r from-green-400 to-blue-400 rounded-full opacity-0 group-hover:opacity-20 transition-opacity duration-300"></span>
                            <svg class="w-6 h-6 mr-3 group-hover:animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z"></path>
                            </svg>
                            <span class="relative z-10">Go to Dashboard</span>
                            <div class="ml-3 w-2 h-2 bg-green-400 rounded-full animate-pulse"></div>
                        </a>

                        <div class="mt-6">
                            <p class="text-blue-100 text-lg">
                                Welcome back, <span class="font-semibold text-white"><?php echo e(Auth::user()->name); ?></span>!
                                Continue managing your construction documents.
                            </p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </section>

        <!-- Footer -->
        <footer class="bg-gray-900 text-white py-12">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center">
                    <div class="flex items-center justify-center mb-4">
                        <svg class="h-8 w-8 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                        </svg>
                        <span class="ml-2 text-2xl font-bold">ConstructFlow</span>
                    </div>
                    <p class="text-gray-400 mb-6">
                        Professional Construction Document Management System
                    </p>
                    <div class="border-t border-gray-800 pt-6">
                        <p class="text-gray-500 text-sm">
                            © <?php echo e(date('Y')); ?> ConstructFlow. Built with Laravel Framework.
                        </p>
                    </div>
                </div>
            </div>
        </footer>
    </body>
</html>
<?php /**PATH /Library/WebServer/Documents/atm-project/resources/views/welcome.blade.php ENDPATH**/ ?>