<?php if (isset($component)) { $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\AppLayout::class, []); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                <?php echo e($document->title); ?>

            </h2>
            <div class="flex space-x-2">
                <a href="<?php echo e(route('documents.download', $document)); ?>" class="btn btn-primary">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    Download
                </a>
                <?php if(Auth::user()->hasRole('Contractor') && $document->contractor_id === Auth::id()): ?>
                    <a href="<?php echo e(route('documents.history', $document)); ?>" class="btn btn-secondary">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        History
                    </a>
                <?php endif; ?>
                <a href="<?php echo e(route('documents.index')); ?>" class="btn btn-secondary">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                    Back to Documents
                </a>
            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <?php if(session('success')): ?>
                <div class="alert alert-success animate-fade-in">
                    <svg class="w-5 h-5 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Main Document Info -->
                <div class="lg:col-span-2">
                    <div class="card animate-fade-in">
                        <div class="card-header">
                            <h3 class="text-lg font-bold text-gray-800">Document Details</h3>
                        </div>
                        <div class="card-body">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="form-label">Title</label>
                                    <p class="text-gray-900 font-medium"><?php echo e($document->title); ?></p>
                                </div>
                                <div>
                                    <label class="form-label">Type</label>
                                    <span class="status-badge status-final"><?php echo e($document->type); ?></span>
                                </div>
                                <div>
                                    <label class="form-label">Contractor</label>
                                    <p class="text-gray-900"><?php echo e($document->contractor->name); ?></p>
                                </div>
                                <div>
                                    <label class="form-label">Current Status</label>
                                    <span class="status-badge
                                        <?php if(str_contains($document->current_status, 'Rejected')): ?>
                                            status-rejected
                                        <?php elseif($document->current_status === 'Final Approved'): ?>
                                            status-approved
                                        <?php else: ?>
                                            status-pending
                                        <?php endif; ?>
                                    ">
                                        <?php echo e($document->current_status); ?>

                                    </span>
                                </div>
                                <div>
                                    <label class="form-label">Uploaded</label>
                                    <p class="text-gray-900"><?php echo e($document->created_at->format('M d, Y \a\t g:i A')); ?></p>
                                </div>
                                <div>
                                    <label class="form-label">Current Version</label>
                                    <p class="text-gray-900">v<?php echo e($document->versions->max('version_number') ?? 1); ?></p>
                                </div>
                            </div>

                            <?php if(Auth::user()->hasRole('Contractor') && $document->contractor_id === Auth::id() && !str_contains($document->current_status, 'Final Approved')): ?>
                                <div class="mt-6 pt-6 border-t border-gray-200">
                                    <h4 class="text-md font-semibold mb-3">Upload New Version</h4>
                                    <form action="<?php echo e(route('documents.upload-version', $document)); ?>" method="POST" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <div class="flex items-end space-x-4">
                                            <div class="flex-1">
                                                <input type="file" name="file" required accept=".pdf,.doc,.docx,.jpg,.png"
                                                    class="form-input">
                                            </div>
                                            <button type="submit" class="btn btn-success">
                                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                                                </svg>
                                                Upload New Version
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Approval History Sidebar -->
                <div class="lg:col-span-1">
                    <div class="card animate-slide-in">
                        <div class="card-header">
                            <h3 class="text-lg font-bold text-gray-800">Approval History</h3>
                        </div>
                        <div class="card-body">
                            <?php if($document->approvals->count() > 0): ?>
                                <div class="space-y-4">
                                    <?php $__currentLoopData = $document->approvals->sortBy('created_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $approval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="flex items-start space-x-3 p-3 bg-gray-50 rounded-lg">
                                            <div class="flex-shrink-0 mt-1">
                                                <?php if($approval->status === 'approved'): ?>
                                                    <div class="w-3 h-3 bg-green-500 rounded-full"></div>
                                                <?php elseif($approval->status === 'rejected'): ?>
                                                    <div class="w-3 h-3 bg-red-500 rounded-full"></div>
                                                <?php else: ?>
                                                    <div class="w-3 h-3 bg-yellow-500 rounded-full"></div>
                                                <?php endif; ?>
                                            </div>
                                            <div class="flex-1 min-w-0">
                                                <div class="flex items-center justify-between">
                                                    <p class="text-sm font-medium text-gray-900"><?php echo e($approval->reviewer->name); ?></p>
                                                    <span class="status-badge
                                                        <?php if($approval->status === 'approved'): ?> status-approved
                                                        <?php elseif($approval->status === 'rejected'): ?> status-rejected
                                                        <?php else: ?> status-pending <?php endif; ?>
                                                    ">
                                                        <?php echo e(ucfirst($approval->status)); ?>

                                                    </span>
                                                </div>
                                                <p class="text-xs text-gray-500"><?php echo e($approval->role); ?> • <?php echo e($approval->created_at->diffForHumans()); ?></p>
                                                <?php if($approval->comments): ?>
                                                    <p class="text-sm text-gray-700 mt-1"><?php echo e($approval->comments); ?></p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-6">
                                    <svg class="mx-auto h-8 w-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                                    </svg>
                                    <p class="text-sm text-gray-500 mt-2">No approvals yet</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Quick Actions -->
                    <?php if(Auth::user()->hasRole(['Consultant', 'ClientA', 'ClientB', 'ClientC'])): ?>
                        <?php
                            $canReview = false;
                            if (Auth::user()->hasRole('Consultant') && $document->current_status === 'Pending Consultant Review') $canReview = true;
                            elseif (Auth::user()->hasRole('ClientA') && $document->current_status === 'Pending Client A Review') $canReview = true;
                            elseif (Auth::user()->hasRole(['ClientB', 'ClientC']) && $document->current_status === 'Pending Client B & C Review') $canReview = true;
                        ?>

                        <?php if($canReview): ?>
                            <div class="card mt-6">
                                <div class="card-header">
                                    <h3 class="text-lg font-bold text-gray-800">Review Actions</h3>
                                </div>
                                <div class="card-body">
                                    <div class="space-y-3">
                                        <a href="<?php echo e(route('approvals.show', $document)); ?>" class="btn btn-success w-full justify-center">
                                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                            </svg>
                                            Review Document
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da)): ?>
<?php $component = $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da; ?>
<?php unset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da); ?>
<?php endif; ?>
<?php /**PATH /Library/WebServer/Documents/atm-project/resources/views/documents/show.blade.php ENDPATH**/ ?>