<!-- Client B & C Dashboard Statistics -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-purple-600 mb-2"><?php echo e($pendingReview ?? 0); ?></div>
            <div class="text-sm text-gray-600">Pending Review</div>
            <div class="text-xs text-gray-500 mt-1">Final Stage</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-gray-600 mb-2"><?php echo e($totalApprovals ?? 0); ?></div>
            <div class="text-sm text-gray-600">Total Reviews</div>
            <div class="text-xs text-gray-500 mt-1">Completed</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-green-600 mb-2"><?php echo e($approved ?? 0); ?></div>
            <div class="text-sm text-gray-600">Approved</div>
            <div class="text-xs text-gray-500 mt-1">Final</div>
        </div>
    </div>
    <div class="card">
        <div class="card-body text-center">
            <div class="text-3xl font-bold text-red-600 mb-2"><?php echo e($rejected ?? 0); ?></div>
            <div class="text-sm text-gray-600">Rejected</div>
            <div class="text-xs text-gray-500 mt-1">Final</div>
        </div>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
    <!-- Documents Awaiting Final Review -->
    <div class="card">
        <div class="card-header">
            <div class="flex items-center justify-between">
                <h3 class="text-lg font-bold text-gray-800">Final Review Queue</h3>
                <?php if(isset($documentsAwaitingReview) && $documentsAwaitingReview->count() > 0): ?>
                    <span class="status-badge status-warning"><?php echo e($documentsAwaitingReview->count()); ?></span>
                <?php endif; ?>
            </div>
        </div>
        <div class="card-body">
            <?php if(isset($documentsAwaitingReview) && $documentsAwaitingReview->count() > 0): ?>
                <div class="space-y-4">
                    <?php $__currentLoopData = $documentsAwaitingReview->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center justify-between p-4 bg-purple-50 rounded-lg border-l-4 border-purple-400">
                            <div class="flex-1">
                                <h4 class="font-medium text-gray-900"><?php echo e($document->title); ?></h4>
                                <p class="text-sm text-gray-600"><?php echo e($document->type); ?> • <?php echo e($document->contractor->name); ?></p>
                                <p class="text-xs text-gray-500">Client A approved <?php echo e($document->updated_at->diffForHumans()); ?></p>

                                <!-- Show other client's approval status -->
                                <?php
                                    $userRole = Auth::user()->hasRole('ClientB') ? 'ClientB' : 'ClientC';
                                    $otherRole = $userRole === 'ClientB' ? 'ClientC' : 'ClientB';
                                    $otherApproval = $document->approvals->where('role', $otherRole)->first();
                                ?>

                                <?php if($otherApproval): ?>
                                    <div class="mt-2">
                                        <span class="text-xs text-gray-500"><?php echo e($otherRole); ?>: </span>
                                        <span class="status-badge
                                            <?php if($otherApproval->status === 'approved'): ?> status-approved
                                            <?php elseif($otherApproval->status === 'rejected'): ?> status-rejected
                                            <?php else: ?> status-pending <?php endif; ?>
                                        ">
                                            <?php echo e(ucfirst($otherApproval->status)); ?>

                                        </span>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="flex flex-col space-y-2">
                                <!-- Only Reject Button (as per requirements) -->
                                <form action="<?php echo e(route('approvals.process', $document)); ?>" method="POST" class="inline">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="action" value="reject">
                                    <button type="submit" class="btn btn-danger btn-sm w-full"
                                            onclick="return confirm('Are you sure you want to reject this document? This will stop the approval process.')">
                                        Reject
                                    </button>
                                </form>
                                <a href="<?php echo e(route('approvals.show', $document)); ?>" class="btn btn-secondary btn-sm w-full">
                                    Review
                                </a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php if($documentsAwaitingReview->count() > 5): ?>
                    <div class="mt-4 text-center">
                        <a href="<?php echo e(route('approvals.index')); ?>" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                            View All <?php echo e($documentsAwaitingReview->count()); ?> Documents →
                        </a>
                    </div>
                <?php endif; ?>
            <?php else: ?>
                <div class="text-center py-8">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path>
                    </svg>
                    <h3 class="mt-2 text-sm font-medium text-gray-900">No documents for final review</h3>
                    <p class="mt-1 text-sm text-gray-500">All documents have been processed.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Status History Panel -->
    <div class="card">
        <div class="card-header">
            <h3 class="text-lg font-bold text-gray-800">Review History</h3>
        </div>
        <div class="card-body">
            <div class="space-y-4">
                <div class="flex items-center justify-between p-3 bg-green-50 rounded-lg">
                    <div class="flex items-center">
                        <div class="w-3 h-3 bg-green-500 rounded-full mr-3"></div>
                        <span class="text-sm font-medium text-gray-900">Approved</span>
                    </div>
                    <span class="text-lg font-bold text-green-600"><?php echo e($approved ?? 0); ?></span>
                </div>

                <div class="flex items-center justify-between p-3 bg-red-50 rounded-lg">
                    <div class="flex items-center">
                        <div class="w-3 h-3 bg-red-500 rounded-full mr-3"></div>
                        <span class="text-sm font-medium text-gray-900">Rejected</span>
                    </div>
                    <span class="text-lg font-bold text-red-600"><?php echo e($rejected ?? 0); ?></span>
                </div>

                <?php if(($approved ?? 0) + ($rejected ?? 0) > 0): ?>
                    <div class="mt-4 pt-4 border-t border-gray-200">
                        <div class="text-center">
                            <div class="text-sm text-gray-600">Approval Rate</div>
                            <div class="text-2xl font-bold text-blue-600">
                                <?php echo e(round((($approved ?? 0) / (($approved ?? 0) + ($rejected ?? 0))) * 100, 1)); ?>%
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Monthly Approval Trends - Stacked Bar Chart -->
<?php if(isset($monthlyApprovals) && $monthlyApprovals->count() > 0): ?>
<div class="card">
    <div class="card-header">
        <h3 class="text-lg font-bold text-gray-800">Monthly Approval Trends</h3>
    </div>
    <div class="card-body">
        <canvas id="monthlyApprovalChart" width="800" height="400"></canvas>
    </div>
</div>
<?php endif; ?>

<!-- Important Notice for Client B & C -->
<div class="card mt-8">
    <div class="card-body">
        <div class="flex items-start space-x-3">
            <div class="flex-shrink-0">
                <svg class="h-6 w-6 text-amber-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                </svg>
            </div>
            <div>
                <h3 class="text-sm font-medium text-gray-900">Final Review Stage</h3>
                <div class="mt-2 text-sm text-gray-600">
                    <p>As <?php echo e(Auth::user()->hasRole('ClientB') ? 'Client B' : 'Client C'); ?>, you have the final say on document approval. You can:</p>
                    <ul class="mt-2 list-disc list-inside space-y-1">
                        <li><strong>Reject documents</strong> to stop the approval process</li>
                        <li><strong>Allow approval</strong> by not rejecting (if both Client B & C don't reject, document becomes "Final Approved")</li>
                        <li><strong>View complete history</strong> of all previous approvals and comments</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Monthly Approval Trends - Stacked Bar Chart
    <?php if(isset($monthlyApprovals) && $monthlyApprovals->count() > 0): ?>
    const monthlyApprovalCtx = document.getElementById('monthlyApprovalChart').getContext('2d');
    new Chart(monthlyApprovalCtx, {
        type: 'bar',
        data: {
            labels: [
                <?php $__currentLoopData = $monthlyApprovals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    '<?php echo e(date("M Y", mktime(0, 0, 0, $month->month, 1, $month->year))); ?>',
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ],
            datasets: [{
                label: 'Approved',
                data: [
                    <?php $__currentLoopData = $monthlyApprovals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($month->approved); ?>,
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ],
                backgroundColor: '#10B981',
                borderColor: '#059669',
                borderWidth: 1
            }, {
                label: 'Rejected',
                data: [
                    <?php $__currentLoopData = $monthlyApprovals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($month->rejected); ?>,
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ],
                backgroundColor: '#EF4444',
                borderColor: '#DC2626',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                x: {
                    stacked: true,
                    grid: {
                        color: 'rgba(0, 0, 0, 0.1)'
                    }
                },
                y: {
                    stacked: true,
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    },
                    grid: {
                        color: 'rgba(0, 0, 0, 0.1)'
                    }
                }
            },
            plugins: {
                legend: {
                    position: 'top',
                    labels: {
                        usePointStyle: true,
                        padding: 20
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(0, 0, 0, 0.8)',
                    titleColor: '#ffffff',
                    bodyColor: '#ffffff',
                    borderColor: 'rgba(255, 255, 255, 0.1)',
                    borderWidth: 1
                }
            }
        }
    });
    <?php endif; ?>
});
</script>
<?php /**PATH /Library/WebServer/Documents/atm-project/resources/views/dashboard/client-bc.blade.php ENDPATH**/ ?>