<?php if (isset($component)) { $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\AppLayout::class, []); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                Assign Role to <?php echo e($user->name); ?>

            </h2>
            <a href="<?php echo e(route('users.index')); ?>" class="btn btn-secondary">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                </svg>
                Back to Users
            </a>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-2xl mx-auto sm:px-6 lg:px-8">
            <?php if($errors->any()): ?>
                <div class="alert alert-error animate-fade-in">
                    <svg class="w-5 h-5 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <strong>Please fix the following errors:</strong>
                    <ul class="list-disc list-inside mt-2">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <div class="card animate-fade-in">
                <div class="card-header">
                    <h3 class="text-lg font-bold text-gray-800">User Information</h3>
                </div>
                <div class="card-body">
                    <div class="flex items-center space-x-4 mb-6">
                        <div class="flex-shrink-0 h-16 w-16">
                            <div class="h-16 w-16 rounded-full bg-blue-500 flex items-center justify-center">
                                <span class="text-white font-bold text-xl">
                                    <?php echo e(substr($user->name, 0, 2)); ?>

                                </span>
                            </div>
                        </div>
                        <div>
                            <h4 class="text-xl font-semibold text-gray-900"><?php echo e($user->name); ?></h4>
                            <p class="text-gray-600"><?php echo e($user->email); ?></p>
                            <p class="text-sm text-gray-500">Member since <?php echo e($user->created_at->format('M d, Y')); ?></p>
                        </div>
                    </div>

                    <div class="mb-6">
                        <label class="form-label">Current Role</label>
                        <?php if($user->roles->count() > 0): ?>
                            <span class="status-badge status-final">
                                <?php echo e($user->roles->first()->name); ?>

                            </span>
                        <?php else: ?>
                            <span class="status-badge bg-gray-100 text-gray-800">No Role Assigned</span>
                        <?php endif; ?>
                    </div>

                    <form action="<?php echo e(route('users.assign-role.store', $user)); ?>" method="POST" class="space-y-6">
                        <?php echo csrf_field(); ?>

                        <div>
                            <label for="role" class="form-label">
                                <svg class="w-4 h-4 mr-1 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.5-1.5a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                                </svg>
                                Select New Role
                            </label>
                            <select name="role" id="role" required class="form-select">
                                <option value="">Choose a role</option>
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($role->name); ?>" <?php echo e(old('role') === $role->name ? 'selected' : ''); ?>>
                                        <?php echo e($role->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Role Descriptions -->
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h5 class="font-semibold text-gray-800 mb-3">Role Descriptions</h5>
                            <div class="space-y-2 text-sm text-gray-600">
                                <div><strong>Contractor:</strong> Can upload and manage their own documents</div>
                                <div><strong>Consultant:</strong> Reviews contractor-submitted documents</div>
                                <div><strong>Client A:</strong> Reviews consultant-approved documents</div>
                                <div><strong>Client B:</strong> Final review stage with rejection rights</div>
                                <div><strong>Client C:</strong> Final review stage with rejection rights</div>
                            </div>
                        </div>

                        <div class="flex items-center justify-between pt-6 border-t border-gray-200">
                            <a href="<?php echo e(route('users.index')); ?>" class="btn btn-secondary">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                                </svg>
                                Cancel
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                Assign Role
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da)): ?>
<?php $component = $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da; ?>
<?php unset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da); ?>
<?php endif; ?>
<?php /**PATH /Library/WebServer/Documents/atm-project/resources/views/users/assign-role.blade.php ENDPATH**/ ?>